/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.installer;

import bitel.billing.common.VersionInfo;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class ScanUtils {
    private Connection con;

    public ScanUtils(Connection con) {
        this.con = con;
    }

    public List<ModuleInfo> getModulesInfo(String packetName) {
        ArrayList<ModuleInfo> result = new ArrayList<ModuleInfo>();
        try {
            File clientJarsDir = new File("client.jars");
            String query = "SELECT name FROM installed_modules";
            if (packetName != null) {
                query = query + " WHERE name='" + packetName + "'";
            }
            PreparedStatement ps = this.con.prepareStatement(query);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                File moduleDir = new File(clientJarsDir, rs.getString(1));
                if (!moduleDir.exists()) continue;
                for (String fileName : moduleDir.list()) {
                    if (!fileName.endsWith(".jar")) continue;
                    try {
                        ZipInputStream zis = new ZipInputStream(new FileInputStream(new File(moduleDir, fileName)));
                        this.scanStream(rs.getString(1), result, zis);
                        zis.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    private void scanStream(String packetName, List<ModuleInfo> result, ZipInputStream zis) throws IOException {
        ZipEntry entry = null;
        while ((entry = zis.getNextEntry()) != null) {
            String entryName = entry.getName();
            if (entryName.endsWith(".jar")) {
                ZipInputStream subStream = new ZipInputStream(zis);
                this.scanStream(packetName, result, subStream);
                continue;
            }
            if (!entryName.startsWith("ru/bitel/bgbilling/properties/") || !entryName.endsWith(".properties")) continue;
            Properties properties = new Properties();
            properties.load(zis);
            VersionInfo versionInfo = new VersionInfo();
            versionInfo.setProperties(properties);
            ModuleInfo moduleInfo = new ModuleInfo();
            moduleInfo.name = versionInfo.getModuleName();
            moduleInfo.version = versionInfo.getVersion();
            moduleInfo.build = versionInfo.getBuildNumber();
            moduleInfo.buildtime = versionInfo.getBuildTime();
            moduleInfo.packetName = packetName;
            result.add(moduleInfo);
        }
    }

    public static class ModuleInfo {
        public String name;
        public String version;
        public String build;
        public String buildtime;
        public String packetName;
    }
}

