/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.installer;

import bitel.billing.server.installer.InstallationCall;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipInputStream;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Utils;

public class PutFile
implements InstallationCall {
    private List<String> replacedFiles;

    public void setReplacedList(List<String> replacedFiles) {
        this.replacedFiles = replacedFiles;
    }

    @Override
    public boolean call(Setup setup, File zip, String param) {
        boolean result = false;
        try {
            String[] prefix_path = param.split(":");
            if (prefix_path.length == 2) {
                String prefix = prefix_path[0];
                File dir = new File(prefix_path[1]);
                dir.mkdirs();
                if (!dir.exists() || !dir.isDirectory()) {
                    System.err.println("Can't find " + prefix_path[1] + "dir");
                } else {
                    FileInputStream fis = new FileInputStream(zip);
                    Map<String, byte[]> map = ServerUtils.getFileEntriesFromZipByPrefix(new ZipInputStream(fis), prefix);
                    for (String key : map.keySet()) {
                        String filePath;
                        File existFile;
                        byte[] value = map.get(key);
                        String fileOrTopFolder = key;
                        int pos = fileOrTopFolder.indexOf(47);
                        if (pos > 0) {
                            fileOrTopFolder = fileOrTopFolder.substring(0, pos);
                        }
                        if (!prefix.equals(fileOrTopFolder)) continue;
                        pos = key.lastIndexOf(47);
                        if (pos > 0) {
                            String folder = key.substring(0, pos + 1);
                            new File(dir.getAbsolutePath() + File.separator + folder).mkdirs();
                        }
                        if ((existFile = new File(filePath = dir.getAbsolutePath() + File.separator + key)).exists() && !PutFile.equalFiles(value, existFile)) {
                            File origFile = new File(filePath + ".orig");
                            if (origFile.exists() && PutFile.equalFiles(value, origFile)) {
                                System.err.println("File doesn't changed " + filePath);
                                continue;
                            }
                            this.replacedFiles.add(filePath);
                            byte[] backup = Utils.readByBlock(new FileInputStream(existFile));
                            FileOutputStream backupFos = new FileOutputStream(filePath + ".bak." + System.currentTimeMillis());
                            backupFos.write(backup);
                            backupFos.close();
                        }
                        FileOutputStream fos = new FileOutputStream(filePath);
                        fos.write(value);
                        fos.close();
                    }
                    fis.close();
                }
                result = true;
            } else {
                System.err.println("Wrong param " + param);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    private static boolean equalFiles(byte[] newFile, File existFile) {
        boolean result;
        boolean bl = result = (long)newFile.length == existFile.length();
        if (result) {
            try {
                FileInputStream fileInputStream = new FileInputStream(existFile);
                byte[] existFileData = Utils.readByBlock(fileInputStream);
                fileInputStream.close();
                int size = newFile.length;
                for (int i = 0; i < size; ++i) {
                    boolean bl2 = result = result && newFile[i] == existFileData[i];
                    if (result) {
                        continue;
                    }
                    break;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }
}

