/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.contract.bean;

import bitel.billing.server.contract.bean.ContractCreateData;
import bitel.billing.server.contract.bean.ContractPattern;
import bitel.billing.server.contract.bean.ContractUtils;
import java.io.ByteArrayOutputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractPatternNamedNumber;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractPatternNamedNumberDao;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.model.IdTitle;

public class ContractPatternManager {
    public static final String TABLE_CONTRACT_PATTERN = "contract_pattern";
    public static final String TITLE_PARAM_CARD = "card";
    public static final String TITLE_PARAM_CARD_SERIES = "card_series";
    protected static final Logger logger = Logger.getLogger(ContractPatternManager.class);
    private static List<ContractCreateData> lastTitles = new ArrayList<ContractCreateData>();
    private Connection con;
    private static final Pattern patternTitle = Pattern.compile("\\$\\{(.+?)(?:(?:\\:(.+?))?|(\\d)?)\\}");

    public ContractPatternManager(Connection con) {
        this.con = con;
    }

    public ContractPattern getPattern(int id) {
        ContractPattern result = null;
        try (PreparedStatement ps = this.con.prepareStatement("SELECT * FROM contract_pattern WHERE id=" + id);){
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                result = new ContractPattern();
                this.loadContractPattern(result, rs);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return result;
    }

    private void loadContractPattern(ContractPattern result, ResultSet rs) throws SQLException {
        Document doc = null;
        byte[] data = rs.getBytes("data");
        if (data != null && data.length > 0) {
            doc = XMLUtils.parseDocument(data);
            result.setData(doc);
        }
        this.deserializePattern(result);
        result.setId(rs.getInt("id"));
        result.setClosesumma(rs.getFloat("closesumma"));
        result.setTariffPlanList(Utils.toList(rs.getString("tpid")));
        result.setGroups(rs.getLong("groups"));
        result.setDaysToLive(rs.getInt("dtl"));
        result.setFc(rs.getInt("fc"));
        result.setMode(rs.getInt("mode"));
        result.setParamsGroupId(rs.getInt("pgid"));
        result.setTitle(rs.getString("title"));
        result.setTariffGroupList(Utils.toIntegerList(rs.getString("tgid")));
        result.setScriptList(Utils.toIntegerList(rs.getString("scrid")));
        result.setNamePattern(rs.getString("name_pattern"));
        result.setPatternId(rs.getInt("patid"));
        result.setDomainId(rs.getInt("domainId"));
        ArrayList<Element> modules = new ArrayList<Element>();
        String query = "SELECT mid FROM contract_pattern_modules WHERE pid=?";
        PreparedStatement ps = this.con.prepareStatement(query);
        ps.setInt(1, result.getId());
        ResultSet rsModules = ps.executeQuery();
        while (rsModules.next()) {
            Element moduleElement = doc.createElement("module");
            moduleElement.setAttribute("mid", rsModules.getString(1));
            modules.add(moduleElement);
        }
        rsModules.close();
        ps.close();
        query = "SELECT sid, mid FROM contract_pattern_services LEFT JOIN service ON sid=id WHERE pid=?";
        ps = this.con.prepareStatement(query);
        ps.setInt(1, result.getId());
        ResultSet rsServices = ps.executeQuery();
        block1: while (rsServices.next()) {
            String mid = rsServices.getString(2);
            for (Element moduleElement : modules) {
                if (!moduleElement.getAttribute("mid").equals(mid)) continue;
                Element addServicesElement = XMLUtils.selectElement(moduleElement, "addServices");
                if (addServicesElement == null) {
                    addServicesElement = XMLUtils.createElement(moduleElement, "addServices");
                }
                XMLUtils.createElement(addServicesElement, "item").setAttribute("sid", rsServices.getString(1));
                continue block1;
            }
        }
        rsServices.close();
        ps.close();
        if (!modules.isEmpty()) {
            Element modulesElement = XMLUtils.selectElement(doc, "/data/modules");
            for (Element moduleElement : modules) {
                modulesElement.appendChild(moduleElement);
            }
        }
    }

    public void updateContaractPattern(int id, ContractPattern pattern) {
        boolean insert = id < 1;
        String query = (insert ? "INSERT INTO " : "UPDATE ") + TABLE_CONTRACT_PATTERN + " SET title=?, closesumma=?, tpid=?, `groups`=?, mode=?, pgid=?, fc=?, dtl=?, tgid=?, scrid=?, name_pattern=?, data=?, patid=?, domainId=?" + (insert ? "" : " WHERE id=?");
        try (PreparedStatement ps = this.con.prepareStatement(query, 1);){
            this.serializePattern(pattern);
            int index = 1;
            ps.setString(index++, pattern.getTitle());
            ps.setFloat(index++, pattern.getClosesumma());
            ps.setString(index++, Utils.toString(pattern.getTariffPlanList()));
            ps.setLong(index++, 0L);
            ps.setInt(index++, pattern.getMode());
            ps.setInt(index++, pattern.getParamsGroupId());
            ps.setInt(index++, pattern.getFc());
            ps.setInt(index++, pattern.getDaysToLive());
            ps.setString(index++, Utils.toString(pattern.getTariffGroupList()));
            ps.setString(index++, Utils.toString(pattern.getScriptList()));
            ps.setString(index++, pattern.getNamePattern());
            ByteArrayOutputStream bos = new ByteArrayOutputStream(4096);
            XMLUtils.serialize((Node)pattern.getData(), bos, "UTF-8");
            ps.setBytes(index++, bos.toByteArray());
            ps.setInt(index++, pattern.getPatternId());
            ps.setInt(index++, pattern.getDomainId());
            if (!insert) {
                ps.setInt(index++, id);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)ps.toString());
            }
            ps.executeUpdate();
            pattern.setId(id > 0 ? id : ServerUtils.lastInsertId(ps));
            query = "DELETE FROM contract_pattern_services WHERE pid=?";
            PreparedStatement psDelete = this.con.prepareStatement(query);
            psDelete.setInt(1, pattern.getId());
            psDelete.executeUpdate();
            psDelete.close();
            query = "DELETE FROM contract_pattern_modules WHERE pid=?";
            psDelete = this.con.prepareStatement(query);
            psDelete.setInt(1, pattern.getId());
            psDelete.executeUpdate();
            psDelete.close();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private void serializePattern(ContractPattern pattern) {
        Element data = pattern.getData().getDocumentElement();
        Element general = data.getOwnerDocument().createElement("general");
        data.appendChild(general);
        general.setAttribute("status", pattern.getStatus() + "");
        general.setAttribute("dtl", pattern.getDaysToLive() + "");
        if (Utils.notBlankString(pattern.getObjectString())) {
            String[] pairs;
            Element objectsElem = data.getOwnerDocument().createElement("objects");
            general.appendChild(objectsElem);
            for (String pair : pairs = pattern.getObjectString().split(",")) {
                String[] curObject = pair.split(":");
                Element objElement = objectsElem.getOwnerDocument().createElement("object");
                objectsElem.appendChild(objElement);
                objElement.setAttribute("type", curObject[0]);
                objElement.setAttribute("amount", curObject[1]);
            }
        }
    }

    private void deserializePattern(ContractPattern pattern) {
        Element general = XMLUtils.selectElement(pattern.getData(), "//data/general");
        if (general != null) {
            pattern.setStatus(Utils.parseInt(general.getAttribute("status")));
            pattern.setDaysToLive(Utils.parseInt(general.getAttribute("dtl")));
        }
    }

    public static String getContractTitle(Connection con, ContractPattern pattern, Calendar date) throws BGException {
        return ContractPatternManager.getContractTitle(con, pattern, date, Collections.emptyMap());
    }

    public static synchronized String getContractTitle(Connection con, ContractPattern pattern, Calendar date, Map<String, Object> titleParams) throws BGException {
        String result = null;
        try (ContractPatternNamedNumberDao numberDao = new ContractPatternNamedNumberDao(con);){
            if (lastTitles.size() > 1000) {
                long time = new Date().getTime() / 1000L;
                lastTitles = lastTitles.stream().filter(s -> time - s.date.getTime() / 1000L < 1200L).collect(Collectors.toList());
            }
            String namePattern = pattern.getNamePattern();
            String regexp = "^";
            Pattern p = Pattern.compile("\\$\\{([\\w_]+)([\\d]*)\\}");
            ArrayList<PatternPart> parts = new ArrayList<PatternPart>(3);
            int numberPosition = 0;
            if (Utils.isEmptyString(namePattern) && titleParams.containsKey(TITLE_PARAM_CARD)) {
                namePattern = "K${card:00000}-${time:yy}";
            }
            int pos = 0;
            int elementPos = 0;
            Matcher m = Pattern.compile("\\$\\{([^}]+)\\}").matcher(namePattern);
            while (m.find()) {
                Matcher m1;
                ++elementPos;
                regexp = regexp + namePattern.substring(pos, m.start());
                pos = m.end();
                int count = 0;
                String letter = m.group(1);
                String format = null;
                Object namedNumber = null;
                if (letter.startsWith("NS")) {
                    String title = letter.substring(2);
                    namedNumber = numberDao.getFromTitle(title);
                    if (namedNumber == null) {
                        throw new BGMessageException("\u0418\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u043d\u044b\u0439 \u043f\u043e\u0440\u044f\u0434\u043a\u043e\u0432\u044b\u0439 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 \u0448\u0430\u0431\u043b\u043e\u043d\u0430 \u0438\u043c\u0435\u043d\u0438 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430 -\"" + title + "\" \u043d\u0435 \u043e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d. \u0421\u043e\u0437\u0434\u0430\u0439\u0442\u0435 \u0442\u0430\u043a\u043e\u0439, \u043b\u0438\u0431\u043e \u043e\u0442\u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u0443\u0439\u0442\u0435 \u0448\u0430\u0431\u043b\u043e\u043d \u0438\u043c\u0435\u043d\u0438");
                    }
                    count = ((ContractPatternNamedNumber)namedNumber).getCountNumber();
                    letter = "NS";
                } else if (letter.matches("(.+)(\\d+)")) {
                    m1 = Pattern.compile("(.+)(\\d+)").matcher(letter);
                    if (!m1.find()) continue;
                    letter = m1.group(1);
                    count = Utils.parseInt(m1.group(2), 0);
                    if (letter.equals("N")) {
                        numberPosition = elementPos;
                    }
                } else if (letter.matches("(.+):(.+)")) {
                    m1 = Pattern.compile("(.+):(.+)").matcher(letter);
                    if (!m1.find()) continue;
                    letter = m1.group(1);
                    format = m1.group(2);
                }
                regexp = regexp + (count > 0 ? "([0-9]{" + count + "})" : "([0-9a-zA-Z\u0430-\u044f\u0410-\u042f_]+)");
                parts.add(new PatternPart(letter, count, format, (ContractPatternNamedNumber)namedNumber));
            }
            regexp = regexp + namePattern.substring(pos) + "$";
            long lastNumber = 0L;
            if (numberPosition > 0) {
                p = Pattern.compile(regexp);
                try {
                    String reg = regexp;
                    for (ContractCreateData n : lastTitles.stream().filter(s -> s.title != null ? s.title.matches(reg) : false).collect(Collectors.toList())) {
                        long number;
                        m = p.matcher(n.title);
                        if (!m.find() || (number = Utils.parseLong(m.group(numberPosition), 0L)) <= lastNumber) continue;
                        lastNumber = number;
                    }
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
                PreparedStatement ps = con.prepareStatement("SELECT title FROM contract WHERE title REGEXP BINARY '" + regexp + "'");
                ResultSet rs = ps.executeQuery();
                while (rs.next()) {
                    long number;
                    m = p.matcher(rs.getString(1));
                    if (!m.find() || (number = Utils.parseLong(m.group(numberPosition), 0L)) <= lastNumber) continue;
                    lastNumber = number;
                }
                rs.close();
                ps.close();
            }
            result = namePattern;
            Collections.sort(parts);
            PatternPart NRpart = null;
            for (PatternPart pp : parts) {
                switch (pp.letter) {
                    case "NS": {
                        String locResult;
                        int i = 0;
                        DecimalFormat dfNS = new DecimalFormat("############" + Utils.multiLetter("0", pp.count));
                        boolean isLastNS = result.indexOf("${") == result.lastIndexOf("${");
                        do {
                            locResult = result.replaceAll(pp.getFullString(), dfNS.format(numberDao.getNextNamedNumberIndex(pp.namedNumber.getTitle())));
                        } while (isLastNS && ContractPatternManager.isContractTitleDuplicated(locResult, false, -1, con) && ++i < 5000);
                        result = locResult;
                        break;
                    }
                    case "N": {
                        DecimalFormat df = new DecimalFormat("############" + Utils.multiLetter("0", pp.count));
                        result = result.replaceAll(pp.getFullString(), df.format(++lastNumber));
                        break;
                    }
                    case "NR": {
                        NRpart = pp;
                        break;
                    }
                    case "Y": {
                        SimpleDateFormat dfY = new SimpleDateFormat(pp.count == 2 ? "yy" : "yyyy");
                        result = result.replaceAll(pp.getFullString(), dfY.format(date.getTime()));
                        break;
                    }
                    case "card_login": 
                    case "card": {
                        Long login = (Long)titleParams.get(TITLE_PARAM_CARD);
                        if (login != null) {
                            if (pp.count > 0 || Utils.notEmptyString(pp.format)) {
                                DecimalFormat dfC = new DecimalFormat(pp.count > 0 ? Utils.multiLetter("0", pp.count) : pp.format);
                                result = result.replaceAll(pp.getFullString(), dfC.format(login));
                                break;
                            }
                            result = result.replaceAll(pp.getFullString(), String.valueOf(login));
                            break;
                        }
                        result = result.replaceAll(pp.getFullString(), "0");
                        break;
                    }
                    case "card_series": {
                        String serial = (String)titleParams.get(TITLE_PARAM_CARD_SERIES);
                        result = result.replaceAll(pp.getFullString(), serial != null ? serial : "0");
                        break;
                    }
                    case "time": {
                        SimpleDateFormat dfT = new SimpleDateFormat(Utils.isEmptyString(pp.format) ? (pp.format = "yy") : pp.format);
                        result = result.replaceAll(pp.getFullString(), dfT.format(date.getTime()));
                    }
                }
            }
            if (NRpart != null) {
                DecimalFormat df = new DecimalFormat(Utils.multiLetter("0", NRpart.count));
                int lastCurNumber = ContractPatternManager.getLastContractWithPattern(result, NRpart.count, con);
                result = result.replaceAll(NRpart.getFullString(), df.format(lastCurNumber));
            }
        }
        catch (Exception e) {
            if (e instanceof BGMessageException) {
                throw new BGMessageException(e.getMessage());
            }
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        if (Utils.notBlankString(result)) {
            lastTitles.add(new ContractCreateData(result));
        }
        return result;
    }

    /*
     * Exception decompiling
     */
    public static synchronized boolean isContractTitleDuplicated(String title, boolean add, int notVerifyContractId, Connection con) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static synchronized void removeContractTitleFromLastTitles(int contractId, Connection con) {
        ContractPatternManager.removeContractTitleFromLastTitles(new ContractUtils(con).getContractTitle(contractId, false));
    }

    public static synchronized void removeContractTitleFromLastTitles(String title) {
        if (title == null) {
            return;
        }
        for (ContractCreateData createData : lastTitles) {
            if (!createData.title.equals(title)) continue;
            lastTitles.remove(createData);
            return;
        }
    }

    public static synchronized void removeLastTitles() {
        lastTitles.clear();
    }

    public Map<Integer, Document> getListPatternData() {
        HashMap<Integer, Document> map = new HashMap<Integer, Document>();
        try (PreparedStatement ps = this.con.prepareStatement("SELECT id, data FROM contract_pattern");){
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                byte[] data = rs.getBytes("data");
                if (data == null || data.length <= 0) continue;
                map.put(rs.getInt("id"), XMLUtils.parseDocument(data));
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return map;
    }

    public List<IdTitle> getPatternTitleList() {
        ArrayList<IdTitle> list = new ArrayList<IdTitle>();
        try (PreparedStatement ps = this.con.prepareStatement("SELECT id, title FROM contract_pattern ORDER BY title");){
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                list.add(new IdTitle(rs.getInt(1), rs.getString(2)));
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return list;
    }

    public void setDataPattern(int idPattern, Document data) {
        try (PreparedStatement ps = this.con.prepareStatement("UPDATE contract_pattern SET data=? WHERE id=" + idPattern);){
            ByteArrayOutputStream bos = new ByteArrayOutputStream(4096);
            XMLUtils.serialize((Node)data, bos, "UTF-8");
            ps.setBytes(1, bos.toByteArray());
            ps.executeUpdate();
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public Map<Integer, Integer> getPatternParameterGroupCountMap() throws BGException {
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        try (PreparedStatement ps = this.con.prepareStatement("SELECT pgid, COUNT(*) FROM contract_pattern GROUP BY pgid");){
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                map.put(rs.getInt(1), rs.getInt(2));
            }
        }
        catch (SQLException ex) {
            throw new BGException(ex);
        }
        return map;
    }

    private static int getLastContractWithPattern(String currentTitle, int numsCount, Connection con) throws SQLException {
        int result = 0;
        Pattern nrPattern = Pattern.compile("([\\S\\s]*)\\$\\{NR" + numsCount + "\\}([\\S\\s]*)");
        String partone = null;
        String parttwo = null;
        Matcher m = nrPattern.matcher(currentTitle);
        if (m.find()) {
            partone = m.group(1);
            parttwo = m.group(2);
        }
        if (Utils.isBlankString(partone) && Utils.isBlankString(parttwo)) {
            return result;
        }
        String query = "SELECT title FROM contract WHERE title LIKE '" + partone + "%" + parttwo + "'";
        PreparedStatement ps = con.prepareStatement(query);
        ResultSet rs = ps.executeQuery(query);
        Pattern takeNumPat = Pattern.compile(partone + "(\\d{" + numsCount + "})" + parttwo);
        while (rs.next()) {
            try {
                int number;
                Matcher takeNum = takeNumPat.matcher(rs.getString(1));
                if (!takeNum.find() || (number = Utils.parseInt(takeNum.group(1))) <= result) continue;
                result = number;
            }
            catch (Exception exception) {}
        }
        rs.close();
        ps.close();
        return result + 1;
    }

    private static class PatternPart
    implements Comparable<PatternPart> {
        public String letter;
        public String format;
        public int count;
        public ContractPatternNamedNumber namedNumber;

        public PatternPart(String letter, int count, String format, ContractPatternNamedNumber namedNumber) {
            this.letter = letter;
            this.count = count;
            this.format = format;
            this.namedNumber = namedNumber;
        }

        public String getFullString() {
            StringBuffer result = new StringBuffer(10);
            result.append("\\$\\{");
            result.append(this.letter);
            if (this.namedNumber != null) {
                result.append("_" + this.namedNumber.getTitle());
            } else {
                if (this.format != null) {
                    result.append(":").append(this.format);
                }
                if (this.count != 0) {
                    result.append(this.count);
                }
            }
            result.append("\\}");
            return result.toString();
        }

        @Override
        public int compareTo(PatternPart o) {
            if (this.namedNumber != null && o.namedNumber != null) {
                return 0;
            }
            if (this.namedNumber != null && o.namedNumber == null) {
                return 1;
            }
            return -1;
        }
    }
}

