/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.contract.action.web;

import bitel.billing.server.contract.action.base.ActionBase;
import bitel.billing.server.contract.bean.ContractUtils;
import java.io.OutputStream;
import java.sql.SQLException;
import javax.servlet.ServletOutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.web.action.XSLManager;
import ru.bitel.common.FOUtils;
import ru.bitel.common.io.Base64;
import ru.bitel.common.util.FileDownload;

public class ActionGetCards
extends ActionBase {
    @Override
    public void doAction() throws SQLException, BGException {
        try {
            String idCard = this.getParameter("id");
            String titleCard = Base64.decode(Base64.decodeWeb(this.getParameter("title")), "utf-8");
            StringBuilder fileName = new StringBuilder();
            fileName.append(titleCard);
            fileName.append(".pdf");
            this.response.setContentType("application/pdf");
            this.response.setHeader("Content-Disposition", FileDownload.getContentDisposition(this.request, fileName.toString(), false));
            DocumentBuilderFactory dFactory = DocumentBuilderFactory.newInstance();
            dFactory.setNamespaceAware(true);
            DocumentBuilder docBuilder = dFactory.newDocumentBuilder();
            Document document = docBuilder.newDocument();
            Element card = document.createElement("card");
            Element user = this.createElement(card, "user");
            user.setAttribute("id", String.valueOf(this.userId));
            XMLOutputFactory factory = XMLOutputFactory.newInstance();
            XMLStreamWriter w = factory.createXMLStreamWriter(new DOMResult(card));
            new ContractUtils(this.con).addContractXML(this.cid, w, true);
            document.appendChild(card);
            ServletOutputStream out = this.response.getOutputStream();
            XSLManager.getInstance().transform((Source)new DOMSource(document), idCard, FOUtils.renderSAXResult((OutputStream)out, "application/pdf"));
            this.request.setAttribute("contentType", (Object)"binary");
            out.flush();
            out.close();
        }
        catch (Exception e) {
            throw new BGException(e);
        }
    }
}

