/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.contract.action;

import bitel.billing.server.contract.action.base.ActionBase;
import bitel.billing.server.contract.bean.CommentPatternManager;
import bitel.billing.server.contract.bean.Contract;
import bitel.billing.server.contract.bean.ContractManager;
import bitel.billing.server.contract.bean.ContractParameterManager;
import bitel.billing.server.util.db.ColumnValue;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.events.ContractAddingSubEvent;
import ru.bitel.bgbilling.kernel.event.events.ContractCreatedEvent;
import ru.bitel.bgbilling.server.util.PswdGen;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class ActionNewContract
extends ActionBase {
    @Override
    public void doAction() throws SQLException, BGException {
        Date date = this.getDateParameter("date", new Date());
        int patternId = this.getIntParameter("pattern_id", -1);
        int superId = this.getIntParameter("super_id", 0);
        int subMode = this.getIntParameter("sub_mode", 0);
        String params = this.getParameter("params", null);
        if (patternId < 0) {
            throw new BGIllegalArgumentException();
        }
        ContractManager contractManager = new ContractManager(this.con);
        if (superId > 0) {
            Contract superContract = contractManager.getContractById(superId);
            if (superContract.isSub()) {
                contractManager.close();
                throw new BGMessageException("\u0412 \u043a\u0430\u0447\u0435\u0441\u0442\u0432\u0435 \u0441\u0443\u043f\u0435\u0440\u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430 \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0432\u044b\u0441\u0442\u0443\u043f\u0430\u0442\u044c \u0441\u0443\u0431\u0434\u043e\u0433\u043e\u0432\u043e\u0440!");
            }
            ContractAddingSubEvent event = new ContractAddingSubEvent((int)this.userId, superContract, null);
            EventProcessor.getInstance().request(event);
            if (Utils.notBlankString(event.getError())) {
                contractManager.close();
                throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u0441\u0443\u0431\u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430: " + event.getError());
            }
        }
        String passwd = PswdGen.generatePassword(this.setup);
        String title = this.getParameter("title");
        String titlePattern = this.getParameter("custom_title", "");
        if (Utils.notBlankString(title) && !contractManager.checkContractTitleOnDublication(title, this.cid)) {
            contractManager.close();
            throw new BGMessageException("\u0414\u043e\u0433\u043e\u0432\u043e\u0440 \u0443\u0436\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442!");
        }
        Contract cont = null;
        try {
            cont = contractManager.createFromPattern(patternId, title, TimeUtils.convertDateToCalendar(date), passwd, Collections.emptyMap(), true, superId, subMode, titlePattern.isEmpty() ? null : titlePattern);
            if (Utils.notBlankString(params)) {
                String where = "cid=" + superId + " AND pid IN (" + params + ")";
                HashMap<String, ColumnValue> valuesPairs = new HashMap<String, ColumnValue>();
                valuesPairs.put("cid", new ColumnValue(true, cont.getId()));
                ContractParameterManager contractParameterManager = new ContractParameterManager(this.con);
                contractParameterManager.copyContractParams(where, valuesPairs);
                contractParameterManager.close();
                new CommentPatternManager(this.con).updateContractComment(cont.getId());
            }
            if (!this.con.getAutoCommit()) {
                this.con.commit();
            }
        }
        catch (BGMessageException e) {
            throw new BGMessageException(e.getMessage());
        }
        catch (BGException e) {
            if (e.getMessage() == null) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            throw new BGException(e.getMessage());
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new BGException(e.getMessage());
        }
        finally {
            contractManager.close();
        }
        EventProcessor.getInstance().request(new ContractCreatedEvent(cont, (int)this.userId, patternId));
        Element contract = this.createElement(this.rootNode, "contract");
        contract.setAttribute("id", String.valueOf(cont.getId()));
        contract.setAttribute("title", cont.getTitle());
    }
}

