/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.contract.action;

import bitel.billing.server.contract.action.base.ActionBase;
import bitel.billing.server.contract.bean.ContractModuleManager;
import java.sql.SQLException;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.kernel.contract.api.common.event.ContractModifiedEvent;
import ru.bitel.bgbilling.kernel.contract.api.common.event.ContractModifiedModuleEvent;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.common.Utils;

public class ActionContractModuleAdd
extends ActionBase {
    @Override
    public void doAction() throws SQLException, BGException {
        int moduleId = this.getIntParameter("module_id", 0);
        List<String> moduleIds = Utils.toList(this.getParameter("module_ids", ""));
        if (this.cid <= 0) {
            throw new BGIllegalArgumentException();
        }
        this.addContractModule(moduleId);
        for (String id : moduleIds) {
            this.addContractModule(Utils.parseInt(id, -1));
        }
    }

    private void addContractModule(int moduleId) throws BGException {
        if (moduleId > 0) {
            ContractModuleManager manager = new ContractModuleManager(this.con);
            manager.addContractModule(this.cid, moduleId);
            this.context.publishAfterCommit(new ContractModifiedEvent(this.userId, this.cid));
            EventProcessor.getInstance().request(new ContractModifiedModuleEvent(moduleId, this.cid, (int)this.userId, ContractModifiedModuleEvent.ModifiedModuleType.ADDED));
        }
    }
}

