/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.contract.action;

import bitel.billing.server.contract.action.base.ActionBase;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.List;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.limit.server.bean.LimitManager;
import ru.bitel.bgbilling.kernel.module.common.bean.User;
import ru.bitel.bgbilling.server.util.UserMap;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Page;

public class ActionContractLimitManage
extends ActionBase {
    @Override
    public void doAction() throws SQLException, BGException {
        int cid = this.getIntParameter("cid", -1);
        if (cid <= 0) {
            return;
        }
        if (this.getParameter("list") != null) {
            Calendar date1 = TimeUtils.convertDateToCalendar(this.getDateParameter("date1"));
            Calendar date2 = TimeUtils.convertDateToCalendar(this.getDateParameter("date2"));
            LimitManager lm = new LimitManager(this.con);
            List<LimitManager.UserLimitMove> moveList = lm.getUserLimitMove(cid, date1, date2);
            Element data = this.createElement(this.createElement(this.rootNode, "table"), "data");
            block5: for (LimitManager.UserLimitMove m : moveList) {
                Element row = this.createElement(data, "row");
                row.setAttribute("id", String.valueOf(m.getId()));
                row.setAttribute("summ", Utils.formatCost(new BigDecimal(m.getSumm())));
                row.setAttribute("date1", TimeUtils.formatDate(m.getDate1()));
                row.setAttribute("date2", TimeUtils.formatDate(m.getDate2()));
                switch (m.getStatus()) {
                    case 0: {
                        row.setAttribute("status", "\u043d\u0435 \u043f\u043e\u0433\u0430\u0448\u0435\u043d\u043e");
                        continue block5;
                    }
                    case 1: {
                        row.setAttribute("status", "\u0447\u0430\u0441\u0442\u0438\u0447\u043d\u043e \u043f\u043e\u0433\u0430\u0448\u0435\u043d\u043e");
                        continue block5;
                    }
                    case 2: {
                        row.setAttribute("status", "\u043f\u043e\u0433\u0430\u0448\u0435\u043d\u043e");
                        continue block5;
                    }
                }
                row.setAttribute("status", "\u043f\u0440\u043e\u0441\u0440\u043e\u0447\u0435\u043d\u043e");
            }
        } else {
            this.log();
        }
    }

    public void log() throws SQLException {
        Page page = this.getPage();
        int order = this.getIntParameter("order", 1);
        Element table = this.createElement(this.rootNode, "table");
        Element data = this.createElement(table, "data");
        String query = "SELECT mode FROM contract_limit_manage_mode WHERE cid=?";
        PreparedStatement ps = this.con.prepareStatement(query);
        ps.setInt(1, this.cid);
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            table.setAttribute("mode", rs.getString(1));
        }
        rs.close();
        ps.close();
        query = "SELECT dt, uid, mode FROM log_contract_limit_manage_mode WHERE cid=? ORDER BY dt " + (order == 1 ? "ASC " : "DESC ") + "LIMIT ?, ?";
        ps = this.con.prepareStatement(query);
        ps.setInt(1, this.cid);
        ps.setInt(2, page.getPageFirstRecordNumber());
        ps.setInt(3, page.getPageSize());
        rs = ps.executeQuery();
        while (rs.next()) {
            Element element = this.createElement(data, "row");
            element.setAttribute("date", TimeUtils.formatFullDate(rs.getTimestamp(1)));
            User u = UserMap.getUser(rs.getInt(2));
            String user = u != null ? u.getTitle() : "?????";
            element.setAttribute("user", user);
            element.setAttribute("value", rs.getInt(3) == 0 ? "\u0440\u0430\u0437\u0431\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u0430\u043d\u043e" : "\u0437\u0430\u0431\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u0430\u043d\u043e");
        }
        rs.close();
        ps.close();
        query = "SELECT COUNT(*) FROM log_contract_limit_manage_mode where cid=? ";
        ps = this.con.prepareStatement(query);
        ps.setInt(1, this.cid);
        rs = ps.executeQuery();
        int records = 0;
        while (rs.next()) {
            records = rs.getInt(1);
        }
        rs.close();
        ps.close();
        page.setRecordCount(records);
        this.setPageAttribute(table, page);
        table.setAttribute("allRecord", String.valueOf(records));
    }
}

