/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.call.action;

import bitel.billing.common.IPUtils;
import bitel.billing.server.call.action.base.ActionBase;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Set;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.server.util.UserMap;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class ActionNasInfo
extends ActionBase {
    @Override
    public void doAction() throws SQLException, BGException {
        int id = this.getIntParameter("id", -1);
        int mid = this.getIntParameter("mid", -1);
        if (id < 0 || mid < 0) {
            return;
        }
        Set<Integer> commonConfigSet = null;
        Element nas = this.createElement(this.rootNode, "nas");
        String query = "SELECT * FROM nas_" + mid + " WHERE id=?";
        PreparedStatement ps = this.con.prepareStatement(query);
        ps.setInt(1, id);
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            nas.setAttribute("title", rs.getString("identifier"));
            nas.setAttribute("secret", rs.getString("secret"));
            nas.setAttribute("addr", IPUtils.convertLongIpToString(rs.getLong("ipaddr")));
            nas.setAttribute("comment", rs.getString("comment"));
            nas.setAttribute("date1", TimeUtils.formatDate(rs.getDate("date1")));
            nas.setAttribute("date2", TimeUtils.formatDate(rs.getDate("date2")));
            nas.setAttribute("config_id", rs.getString("config_id"));
            nas.setAttribute("vendor", rs.getString("vendor"));
            commonConfigSet = Utils.toIntegerSet(rs.getString("common_config_id"));
            Element script = this.createElement(nas, "script");
            this.stringToLines(script, rs.getString("script"));
        }
        rs.close();
        ps.close();
        Element table = this.createElement(this.rootNode, "table");
        Element data = this.createElement(table, "data");
        query = "SELECT id, dt, title, uid FROM nas_config_" + mid + " WHERE nas_id=? ORDER BY dt desc";
        ps = this.con.prepareStatement(query);
        ps.setInt(1, id);
        rs = ps.executeQuery();
        while (rs.next()) {
            Element row = this.createElement(data, "row");
            row.setAttribute("f0", rs.getString(1));
            row.setAttribute("f1", "");
            row.setAttribute("f2", TimeUtils.formatFullDate(rs.getTimestamp(2)));
            row.setAttribute("f3", rs.getString(3));
            row.setAttribute("f4", UserMap.getUser(rs.getInt(4)).getName());
        }
        rs.close();
        ps.close();
        Element commonTable = this.createElement(this.rootNode, "commonTable");
        data = this.createElement(commonTable, "data");
        query = "SELECT id, dt, title, uid FROM nas_config_" + mid + " WHERE nas_id=0 ORDER BY dt desc";
        ps = this.con.prepareStatement(query);
        rs = ps.executeQuery();
        while (rs.next()) {
            Element row = this.createElement(data, "row");
            Integer cur_id = rs.getInt(1);
            row.setAttribute("f0", rs.getString(1));
            row.setAttribute("f1", commonConfigSet.contains(cur_id) ? "1" : "0");
            row.setAttribute("f2", TimeUtils.formatFullDate(rs.getTimestamp(2)));
            row.setAttribute("f3", rs.getString(3));
            row.setAttribute("f4", UserMap.getUser(rs.getInt(4)).getName());
        }
        rs.close();
        ps.close();
    }
}

