/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.admin.resource.bean;

import bitel.billing.server.admin.resource.bean.NumberResourceUse;
import bitel.billing.server.admin.resource.bean.ResourceUseManager;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.TimeUtils;

public class NumberResourceUseManager
extends ResourceUseManager<NumberResourceUse> {
    public NumberResourceUseManager(Connection con, int mid) {
        super(con, mid);
    }

    @Override
    protected String getTableName() {
        return "number_resource_use";
    }

    @Override
    protected NumberResourceUse getResourceUseFromRs(ResultSet rs) {
        NumberResourceUse result = new NumberResourceUse();
        try {
            this.loadStandartResourceUseFromRs(result, rs);
            result.setDateReserve(rs.getDate("ruse.date_reserve"));
            result.setComment(rs.getString("ruse.comment"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public Map<String, List<NumberResourceUse>> getResourceUseMap() {
        HashMap<String, List<NumberResourceUse>> result = new HashMap<String, List<NumberResourceUse>>();
        try {
            String query = "SELECT resource.number, use.date1, use.date2, use.date_reserve FROM " + this.tableName + " AS use LEFT JOIN number_resource_" + this.mid + " AS resource ON use.resource_id=resource.id";
            PreparedStatement ps = this.con.prepareStatement(query);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                String number = rs.getString(1);
                NumberResourceUse use = new NumberResourceUse();
                use.setDateFrom(rs.getDate("date1"));
                use.setDateTo(rs.getDate("date2"));
                use.setDateReserve(rs.getDate("date_reserve"));
                ArrayList<NumberResourceUse> useList = (ArrayList<NumberResourceUse>)result.get(number);
                if (useList == null) {
                    useList = new ArrayList<NumberResourceUse>();
                    result.put(number, useList);
                }
                useList.add(use);
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public boolean checkResourceOutRange(int resourceId, Calendar date1, Calendar date2) {
        boolean result = false;
        try {
            java.sql.Date sqlDate1 = TimeUtils.convertCalendarToSqlDate(date1);
            java.sql.Date sqlDate2 = TimeUtils.convertCalendarToSqlDate(date2);
            String query = "SELECT COUNT(*) FROM " + this.tableName + " WHERE resource_id=? AND not (((? IS NULL) OR (? IS NOT NULL AND date1 IS NOT NULL AND date1>=? )) AND((? IS NULL) OR (? IS NOT NULL AND date2 IS NOT NULL AND date2<=? )))";
            PreparedStatement ps = this.con.prepareStatement(query);
            int index = 1;
            ps.setInt(index++, resourceId);
            ps.setDate(index++, sqlDate1);
            ps.setDate(index++, sqlDate1);
            ps.setDate(index++, sqlDate1);
            ps.setDate(index++, sqlDate2);
            ps.setDate(index++, sqlDate2);
            ps.setDate(index++, sqlDate2);
            ResultSet rs = ps.executeQuery();
            result = rs.next() && rs.getInt(1) > 0;
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    @Override
    protected void insertResourceUseList(int resourceId, List<NumberResourceUse> resourceUseList) throws Exception {
        String query = "INSERT INTO " + this.tableName + " SET resource_id=?, cid=?, date1=?, date2=?, date_reserve=?, comment=?, reserve_user_id=?";
        PreparedStatement psInsert = this.con.prepareStatement(query);
        psInsert.setInt(1, resourceId);
        for (NumberResourceUse ruse : resourceUseList) {
            psInsert.setInt(2, ruse.getContractId());
            psInsert.setDate(3, TimeUtils.convertDateToSqlDate(ruse.getDateFrom()));
            psInsert.setDate(4, TimeUtils.convertDateToSqlDate(ruse.getDateTo()));
            psInsert.setDate(5, TimeUtils.convertDateToSqlDate(ruse.getDateReserve()));
            psInsert.setString(6, ruse.getComment());
            psInsert.setInt(7, ruse.getUserId());
            psInsert.executeUpdate();
        }
        psInsert.close();
    }

    @Override
    public void closeResourceUse(int cid, Date date) {
        try {
            PreparedStatement ps = this.con.prepareStatement("UPDATE " + this.tableName + " SET date2=?, date_reserve=? WHERE cid=? AND date2 is null");
            ps.setDate(1, TimeUtils.convertDateToSqlDate(date));
            java.sql.Date dateReserve = null;
            if (Setup.getSetup().getModuleSetup(this.mid).getBoolean("phone.resource.reserve", false)) {
                int reserveMothCount = Setup.getSetup().getModuleSetup(this.mid).getInt("phone.resource.reserve.month.count", 1);
                dateReserve = TimeUtils.convertDateToSqlDate(TimeUtils.plusPeriod(date, 2, reserveMothCount));
            }
            ps.setDate(2, dateReserve);
            ps.setInt(3, cid);
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

