/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.admin.integration.bean;

import bitel.billing.server.admin.integration.bean.Register;
import bitel.billing.server.admin.integration.bean.RegisterItem;
import bitel.billing.server.admin.integration.bean.RegisterItemManager;
import bitel.billing.server.contract.bean.BalanceUtils;
import bitel.billing.server.contract.bean.Contract;
import bitel.billing.server.contract.bean.ContractManager;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.Charge;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.Payment;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.ChargeDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.PaymentDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.ChargeEvent;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.ContractBalanceChangedEvent;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.PaymentEvent;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;

public class RegisterManager {
    private Connection con;

    public RegisterManager(Connection con) {
        this.con = con;
    }

    public Register getRegisterById(int id) {
        Register result = null;
        try {
            String query = "SELECT * FROM payment_register WHERE id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, id);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                result = new Register();
                this.loadRegisterFromRS(result, rs);
            }
            rs.close();
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    @Deprecated
    public Register getRegisterByID(int id) {
        return this.getRegisterById(id);
    }

    public void updateRegister(Register pr) {
        try {
            String query = null;
            PreparedStatement ps = null;
            if (pr.getId() <= 0) {
                query = "INSERT INTO payment_register ( date, title, load_time, count, errorCount, summa, processed, process_time, load_log, ptitle, regtype )VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
                ps = this.con.prepareStatement(query, 1);
            } else {
                query = "UPDATE payment_register SET date=?, title=?, load_time=?, count=?, errorCount=?, summa=?, processed=?, process_time=?, load_log=?, ptitle=?, regtype=? WHERE id=?";
                ps = this.con.prepareStatement(query);
                ps.setInt(12, pr.getId());
            }
            ps.setDate(1, TimeUtils.convertDateToSqlDate(pr.getDate()));
            ps.setString(2, pr.getTitle());
            ps.setTimestamp(3, TimeUtils.convertCalendarToTimestamp(pr.getLoadTime()));
            ps.setInt(4, pr.getStringsCount());
            ps.setInt(5, pr.getErrorCount());
            ps.setBigDecimal(6, pr.getSumm());
            ps.setInt(7, pr.isProcessed() ? 1 : 0);
            ps.setTimestamp(8, TimeUtils.convertCalendarToTimestamp(pr.getProcessTime()));
            ps.setString(9, pr.getLoadLog());
            ps.setString(10, pr.getPatternTitle());
            ps.setInt(11, pr.getRegisterType());
            ps.executeUpdate();
            if (pr.getId() <= 0) {
                pr.setId(ServerUtils.lastInsertId(ps));
            }
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void deleteRegister(int id) {
        try {
            String query = "DELETE FROM payment_register WHERE id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, id);
            ps.executeUpdate();
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public List<Register> getRegisterList(Calendar date1, Calendar date2, int limit) {
        return this.getRegisterList(date1, date2, limit, 0);
    }

    public List<Register> getRegisterList(Calendar date1, Calendar date2, int limit, int regType) {
        ArrayList<Register> result = new ArrayList<Register>();
        try {
            String query = "SELECT * FROM payment_register WHERE ( ISNULL(?) OR ?<=date ) AND ( ISNULL(?) OR ?>=date ) AND regtype=? ORDER BY date DESC LIMIT ?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setDate(1, TimeUtils.convertCalendarToSqlDate(date1));
            ps.setDate(2, TimeUtils.convertCalendarToSqlDate(date1));
            ps.setDate(3, TimeUtils.convertCalendarToSqlDate(date2));
            ps.setDate(4, TimeUtils.convertCalendarToSqlDate(date2));
            ps.setInt(5, regType);
            ps.setInt(6, limit);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                Register pr = new Register();
                this.loadRegisterFromRS(pr, rs);
                result.add(pr);
            }
            rs.close();
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    private void loadRegisterFromRS(Register result, ResultSet rs) throws SQLException {
        result.setId(rs.getInt("id"));
        result.setDate(rs.getDate("date"));
        result.setRegisterType(rs.getInt("regtype"));
        result.setLoadTime(TimeUtils.convertTimestampToCalendar(rs.getTimestamp("load_time")));
        result.setStringsCount(rs.getInt("count"));
        result.setErrorCount(rs.getInt("errorCount"));
        result.setSumm(rs.getBigDecimal("summa"));
        result.setTitle(rs.getString("title"));
        result.setProcessed(rs.getInt("processed") > 0);
        result.setProcessTime(TimeUtils.convertTimestampToCalendar(rs.getTimestamp("process_time")));
        result.setLoadLog(rs.getString("load_log"));
        result.setPatternTitle(rs.getString("ptitle"));
    }

    public void processRegister(int userId, Register pr) throws BGException, SQLException {
        RegisterItemManager rim = new RegisterItemManager(this.con);
        BalanceUtils bu = new BalanceUtils(this.con);
        ContractManager cm = new ContractManager(this.con);
        if (pr.getRegisterType() == 1) {
            ChargeDao chargeManager = new ChargeDao(this.con);
            for (RegisterItem item : rim.getRegisterItems(pr)) {
                Charge charge = new Charge();
                charge.setDate(item.getDate());
                charge.setContractId(item.getContractId());
                charge.setComment(item.getBalanceItemComment());
                charge.setTypeId(item.getBalanceItemTypeId());
                charge.setSum(item.getSumma());
                charge.setUserId(userId);
                Contract contract = cm.getContractById(charge.getContractId());
                chargeManager.update(charge);
                this.con.commit();
                bu.updateBalance(charge.getDate(), contract);
                this.con.commit();
                EventProcessor.getInstance().publish(new ChargeEvent(userId, charge));
                EventProcessor.getInstance().publish(new ContractBalanceChangedEvent(contract.getId(), 4, charge.getSum()));
                item.setBalanceItemId(charge.getId());
                rim.updateRegisterItem(pr, item);
            }
        } else {
            PaymentDao paymentManager = new PaymentDao(this.con);
            for (RegisterItem item : rim.getRegisterItems(pr)) {
                Payment payment = new Payment();
                payment.setDate(item.getDate());
                payment.setContractId(item.getContractId());
                payment.setComment(item.getBalanceItemComment());
                payment.setTypeId(item.getBalanceItemTypeId());
                payment.setSum(item.getSumma());
                payment.setUserId(userId);
                Contract contract = cm.getContractById(payment.getContractId());
                paymentManager.update(payment);
                bu.updateBalance(payment.getDate(), contract);
                this.con.commit();
                EventProcessor.getInstance().publish(new PaymentEvent(userId, payment));
                EventProcessor.getInstance().publish(new ContractBalanceChangedEvent(contract.getId(), 3, payment.getSum()));
                item.setBalanceItemId(payment.getId());
                rim.updateRegisterItem(pr, item);
            }
        }
        cm.recycle();
        bu.close();
        pr.setProcessed(true);
        this.updateRegister(pr);
    }
}

