/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.admin.integration.bean;

import bitel.billing.server.admin.integration.bean.RegisterLoadPattern;
import bitel.billing.server.contract.bean.find.SearchContract;
import bitel.billing.server.contract.bean.find.SearchContracts;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Utils;

public class RegisterLoadPatternManager {
    private static final Logger log = Logger.getLogger(RegisterLoadPatternManager.class);
    private Setup setup;

    public RegisterLoadPatternManager(Setup setup) {
        this.setup = setup;
    }

    public List<RegisterLoadPattern> getLoadPatterns(int regType) {
        return this.getPatterns(regType);
    }

    private List<RegisterLoadPattern> getPatterns(int registerType) {
        ArrayList<RegisterLoadPattern> result = new ArrayList<RegisterLoadPattern>();
        String prefix = registerType == 1 ? "charge.load.pattern." : "payment.load.pattern.";
        Set keys = Utils.toSet(this.setup.get(prefix + "keys", "")).stream().map(e -> e.trim()).collect(Collectors.toSet());
        if (keys.isEmpty()) {
            int id = 0;
            while (this.setup.get(prefix + ++id, null) != null) {
                keys.add(String.valueOf(id));
            }
        }
        for (String key : keys) {
            try {
                int positionDate;
                String title = this.setup.get(prefix + key, "");
                String typeStr = registerType == 1 ? ".charge_type" : ".payment_type";
                String[] balanceItemTypes = this.setup.get(prefix + key + typeStr, "").split(",");
                int type = this.setup.getInt(prefix + key + ".type", 1);
                RegisterLoadPattern registerPattern = new RegisterLoadPattern(this.setup, key, title, type, balanceItemTypes, registerType);
                registerPattern.setPatternTitle(this.setup.get(prefix + key, null));
                String patternStr = this.setup.get(prefix + key + ".regexp", null);
                if (Utils.notBlankString(patternStr)) {
                    registerPattern.setPattern(Pattern.compile(patternStr));
                }
                registerPattern.setSummaPos(this.setup.get(prefix + key + ".position_sum", "").split(","));
                registerPattern.setCommentPositions(Utils.toList(this.setup.get(prefix + key + ".position_comment", "")).toArray(new String[0]));
                registerPattern.setCommentDelimiter(this.setup.get(prefix + key + ".comment_delimiter", " "));
                String idPos = this.setup.get(prefix + key + ".position_id", null);
                if (Utils.parseInt(idPos) > 0) {
                    registerPattern.setIdPos(Utils.parseInt(idPos));
                }
                if ((positionDate = this.setup.getInt(prefix + key + ".position_date", 0)) > 0) {
                    registerPattern.setDatePos(positionDate);
                    try {
                        registerPattern.setDateFormat(new SimpleDateFormat(this.setup.get(prefix + key + ".date_format", null)));
                    }
                    catch (Exception e2) {
                        throw new BGException("Date format parse error");
                    }
                }
                HashMap<String, String> params = new HashMap<String, String>();
                for (Map.Entry<String, String> entry : this.setup.sub(prefix + key + ".search.").entrySet()) {
                    params.put(entry.getKey(), entry.getValue());
                }
                SearchContracts searches = new SearchContracts(params);
                boolean none = true;
                for (SearchContract s : searches.searchContracts) {
                    if (s.pos == 0) continue;
                    none = false;
                    break;
                }
                if (none) {
                    throw new Exception(" one of search position must be defined ");
                }
                registerPattern.setSearchContracts(searches);
                registerPattern.setEncoding(this.setup.get(prefix + key + ".encoding", "UTF-8"));
                registerPattern.setSummaReplace(this.setup.get(prefix + key + ".summa.replace", null));
                registerPattern.setZeroEncoding(this.setup.getInt(prefix + key + ".encoding.clear", 1) > 0);
                result.add(registerPattern);
            }
            catch (Exception ex) {
                log.error((Object)(" error loading " + (registerType == 1 ? "Charge" : "Payment") + " Load Pattern " + ex.getMessage()));
            }
        }
        return result;
    }

    public Map<String, RegisterLoadPattern> getLoadPatternMap() {
        HashMap<String, RegisterLoadPattern> result = new HashMap<String, RegisterLoadPattern>();
        for (RegisterLoadPattern pattern : this.getLoadPatterns(0)) {
            result.put(pattern.getKey(), pattern);
        }
        return result;
    }

    public RegisterLoadPattern getLoadPatternByKey(String key, int registerType) {
        for (RegisterLoadPattern pattern : this.getLoadPatterns(registerType)) {
            if (!pattern.getKey().equals(key)) continue;
            return pattern;
        }
        return null;
    }
}

