/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.admin.bgsecure.bean;

import bitel.billing.server.admin.bgsecure.bean.Group;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.Utils;

public class GroupManager {
    private Connection con;

    public GroupManager(Connection con) {
        this.con = con;
    }

    public List<Group> getGroupList() {
        ArrayList<Group> result = new ArrayList<Group>(20);
        try {
            String query = "SELECT * FROM bgs_group ORDER BY title";
            PreparedStatement ps = this.con.prepareStatement(query);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                Group group = new Group();
                this.loadFromRS(rs, group);
                result.add(group);
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public Map<Integer, Group> getGroupMap() {
        HashMap<Integer, Group> result = new HashMap<Integer, Group>(20);
        try {
            String query = "SELECT * FROM bgs_group ORDER BY title";
            PreparedStatement ps = this.con.prepareStatement(query);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                Group group = new Group();
                this.loadFromRS(rs, group);
                result.put(group.getId(), group);
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public Group getGroupById(int id) {
        Group result = null;
        try {
            String query = "SELECT * FROM bgs_group WHERE id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, id);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                result = new Group();
                this.loadFromRS(rs, result);
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public void deleteGroup(int id) {
        try {
            String query = "DELETE FROM bgs_group WHERE id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, id);
            ps.executeUpdate();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void updateGroup(Group group) {
        try {
            String query = null;
            PreparedStatement ps = null;
            if (group.getId() <= 0) {
                query = "INSERT INTO bgs_group SET title=?, comment=?";
                ps = this.con.prepareStatement(query, 1);
            } else {
                query = "UPDATE bgs_group SET title=?, comment=? WHERE id=?";
                ps = this.con.prepareStatement(query);
                ps.setInt(3, group.getId());
            }
            ps.setString(1, group.getTitle());
            ps.setString(2, group.getComment());
            ps.executeUpdate();
            if (group.getId() <= 0) {
                group.setId(ServerUtils.lastInsertId(ps));
            }
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void updateGroupPermitions1(int gid, long contractGroups, List<String> pids, List<String> opids) {
        this.updateGroupPermitions(gid, contractGroups, 1, pids, opids);
    }

    public void updateGroupPermitions(int gid, long contractGroups, int contractGroupsMode, List<String> pids, List<String> opids) {
        try {
            String query = null;
            PreparedStatement ps = null;
            if (gid > 0) {
                query = "UPDATE bgs_group SET cgr=?, cgr_mode=?, pids=?, opids=? WHERE id=?";
                ps = this.con.prepareStatement(query);
                ps.setLong(1, contractGroups);
                ps.setInt(2, contractGroupsMode);
                ps.setString(3, Utils.toString(pids));
                ps.setString(4, Utils.toString(opids));
                ps.setInt(5, gid);
                ps.executeUpdate();
                ps.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Map<Integer, Integer> getGroupUserCount() throws BGException {
        HashMap<Integer, Integer> groupUserCountMap = new HashMap<Integer, Integer>();
        try {
            Statement st = this.con.createStatement();
            ResultSet rs = st.executeQuery("SELECT gid, COUNT(*) FROM bgs_user_group GROUP BY gid");
            while (rs.next()) {
                groupUserCountMap.put(rs.getInt(1), rs.getInt(2));
            }
            rs.close();
            st.close();
        }
        catch (SQLException ex) {
            throw new BGException(ex);
        }
        return groupUserCountMap;
    }

    public List<Integer> getGroupUsers(int groupID) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        try {
            String query = "SELECT uid FROM bgs_user_group WHERE gid=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, groupID);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.add(rs.getInt(1));
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public void deleteUserGroup(int userId) throws BGException {
        try {
            PreparedStatement ps = this.con.prepareStatement("DELETE FROM bgs_user_group WHERE uid=?");
            ps.setInt(1, userId);
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException ex) {
            throw new BGException(ex);
        }
    }

    private void loadFromRS(ResultSet rs, Group group) throws SQLException {
        Pattern pattern = Pattern.compile("^\\d+$");
        List<String> pids = Utils.toList(rs.getString("pids"));
        for (int index = 0; index < pids.size(); ++index) {
            if (!pattern.matcher(pids.get(index)).matches()) continue;
            pids.set(index, pids.get(index).concat("C"));
        }
        group.setId(rs.getInt("id"));
        group.setTitle(rs.getString("title"));
        group.setComment(rs.getString("comment"));
        group.setContractGroups(rs.getLong("cgr"));
        group.setContractGroupsMode(rs.getInt("cgr_mode"));
        group.setRuleAccessContractParameter(pids);
        group.setRuleAccessObjectParameter(Utils.toList(rs.getString("opids")));
    }
}

