/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.admin.action;

import bitel.billing.server.admin.action.base.ActionBase;
import bitel.billing.server.task.TaskBaseRunner;
import bitel.billing.server.task.bean.RunTaskDataManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.task.server.TaskCache;

public class ActionRunScheduledTask
extends ActionBase {
    @Override
    public void doAction() throws SQLException, BGException {
        int id = this.getIntParameter("id", -1);
        if (id <= 0) {
            throw new BGIllegalArgumentException();
        }
        String query = "SELECT  st.id, st.params, st.class, st.module_id, sc.class, sc.title FROM scheduled_tasks AS st LEFT JOIN scheduled_class AS sc ON st.class_id = sc.id WHERE st.id=?";
        PreparedStatement ps = this.con.prepareStatement(query);
        ps.setInt(1, id);
        ResultSet rs = ps.executeQuery();
        if (rs.next()) {
            TaskBaseRunner task;
            int taskId = rs.getInt("st.id");
            String params = rs.getString("st.params");
            String className = rs.getString("st.class") != null ? rs.getString("st.class") : rs.getString("sc.class");
            String title = TaskCache.getInstance().getTaskDescription(className) != null ? TaskCache.getInstance().getTaskDescription(className) : rs.getString("sc.title");
            String moduleId = rs.getString("st.module_id");
            try {
                task = new TaskBaseRunner(className, new Date(), taskId, params, moduleId);
            }
            catch (Exception e) {
                rs.close();
                ps.close();
                throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0441\u0442\u0430\u0440\u0442\u0430 \u0437\u0430\u0434\u0430\u043d\u0438\u044f: " + title);
            }
            new RunTaskDataManager(this.con).addTask(task);
            this.setMsg("\u0417\u0430\u0434\u0430\u043d\u0438\u0435 \"" + title + "\" \u043f\u043e\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u043e \u043d\u0430 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0435");
        }
        rs.close();
        ps.close();
    }
}

