/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.common;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.common.Utils;

public class RangeParser {
    private long commonPrefix;
    private int commonPrefixLength;
    private List<Range> rangeList = new ArrayList<Range>();

    public RangeParser(String data) throws BGException {
        this.rangeList.clear();
        this.commonPrefixLength = data.indexOf("|");
        if (this.commonPrefixLength > 0) {
            try {
                this.commonPrefix = Long.parseLong(data.substring(0, this.commonPrefixLength));
            }
            catch (Exception e) {
                throw new BGException("\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u0435\u0434\u0438\u043d\u044b\u0439 \u043f\u0440\u0435\u0444\u0438\u043a\u0441: " + data.substring(0, this.commonPrefixLength));
            }
            data = data.substring(this.commonPrefixLength + 1);
        }
        StringTokenizer st = new StringTokenizer(data, ";,");
        while (st.hasMoreTokens()) {
            String token = st.nextToken().trim().replaceAll("\\s", "");
            Range range = new Range();
            int lengthFrom = 0;
            int lengthTo = 0;
            int pos = token.indexOf("-");
            if (pos > 0) {
                try {
                    String fromToken = token.substring(0, pos).trim();
                    String toToken = token.substring(pos + 1).trim();
                    lengthFrom = fromToken.length();
                    lengthTo = toToken.length();
                    range.from = Long.parseLong(fromToken);
                    range.to = Long.parseLong(toToken);
                }
                catch (Exception e) {
                    throw new BGException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0440\u0430\u0437\u0431\u043e\u0440\u0430 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430: " + token);
                }
            }
            try {
                range.from = range.to = Long.parseLong(token);
                lengthFrom = lengthTo = token.length();
            }
            catch (Exception e) {
                throw new BGException("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0430\u0440\u0441\u0438\u043d\u0433\u0430 \u043f\u0440\u0435\u0444\u0438\u043a\u0441\u0430: " + token);
            }
            if (lengthFrom != lengthTo) {
                throw new BGException("\u041d\u0435 \u0441\u043e\u0432\u043f\u0430\u0434\u0430\u044e\u0442 \u0434\u043b\u0438\u043d\u044b \u043f\u0440\u0435\u0444\u043a\u0438\u0441\u043e\u0432: " + token);
            }
            range.length = lengthFrom;
            if (range.from > range.to) {
                throw new BGException("\u041a\u043e\u043d\u0435\u0446 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430 \u043c\u0435\u043d\u044c\u0448\u0435 \u043d\u0430\u0447\u0430\u043b\u0430: " + token);
            }
            this.rangeList.add(range);
        }
    }

    public boolean checkPrefix(String number) {
        return this.checkPrefixWithResult((String)number).result;
    }

    public CheckResult checkPrefixWithResult(String number) {
        CheckResult result = new CheckResult();
        result.result = false;
        if (this.commonPrefixLength > 0) {
            if (this.commonPrefixLength < number.length()) {
                String start = number.substring(0, this.commonPrefixLength);
                number = number.substring(this.commonPrefixLength);
                result.result = Utils.parseLong(start) == this.commonPrefix;
                result.length += this.commonPrefixLength;
            }
        } else {
            result.result = true;
        }
        if (result.result) {
            result.result = false;
            long prefix = 0L;
            long lastPrefix = 0L;
            int lastLength = 0;
            for (Range range : this.rangeList) {
                if (range.length > number.length()) continue;
                prefix = range.length == lastLength ? lastPrefix : Utils.parseLong(number.substring(0, range.length));
                boolean bl = result.result = range.from <= prefix && prefix <= range.to;
                if (result.result) {
                    result.length += range.length;
                    break;
                }
                lastPrefix = prefix;
                lastLength = range.length;
            }
        }
        return result;
    }

    private static class Range {
        public long from;
        public long to;
        public int length;

        private Range() {
        }
    }

    public static class CheckResult {
        public boolean result;
        public int length;
    }
}

