/*
 * Decompiled with CFR 0.152.
 */
package uk.co.westhawk.snmp.stack;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import uk.co.westhawk.snmp.stack.AsnDecoderv2c;
import uk.co.westhawk.snmp.stack.AsnEncoderv2c;
import uk.co.westhawk.snmp.stack.AsnObject;
import uk.co.westhawk.snmp.stack.AsnPduSequence;
import uk.co.westhawk.snmp.stack.DecodingException;
import uk.co.westhawk.snmp.stack.EncodingException;
import uk.co.westhawk.snmp.stack.GetBulkPdu;
import uk.co.westhawk.snmp.stack.GetNextPdu;
import uk.co.westhawk.snmp.stack.GetPdu;
import uk.co.westhawk.snmp.stack.InformPdu;
import uk.co.westhawk.snmp.stack.Pdu;
import uk.co.westhawk.snmp.stack.SetPdu;
import uk.co.westhawk.snmp.stack.SnmpContext;
import uk.co.westhawk.snmp.stack.SnmpContextv2cFace;
import uk.co.westhawk.snmp.stack.TrapPduv2;

public class SnmpContextv2c
extends SnmpContext
implements SnmpContextv2cFace,
Cloneable {
    private static final String version_id = "@(#)$Id: SnmpContextv2c.java,v 3.15 2006/11/29 16:23:33 birgit Exp $ Copyright Westhawk Ltd";

    public SnmpContextv2c(String host, int port) throws IOException {
        super(host, port);
    }

    public SnmpContextv2c(String host, int port, String typeSocketA) throws IOException {
        super(host, port, typeSocketA);
    }

    public SnmpContextv2c(String host, int port, String bindAddress, String typeSocketA) throws IOException {
        super(host, port, bindAddress, typeSocketA);
    }

    public int getVersion() {
        return 1;
    }

    public byte[] encodePacket(byte msg_type, int rId, int errstat, int errind, Enumeration ve, Object obj) throws IOException, EncodingException {
        byte[] packet = null;
        if (this.isDestroyed) {
            throw new EncodingException("Context can no longer be used, since it is already destroyed");
        }
        AsnEncoderv2c enc = new AsnEncoderv2c();
        ByteArrayOutputStream bay = enc.EncodeSNMPv2c(this, msg_type, rId, errstat, errind, ve);
        int sz = bay.size();
        if (sz > this.maxRecvSize) {
            throw new EncodingException("Packet size (" + sz + ") is > maximum size (" + this.maxRecvSize + ")");
        }
        packet = bay.toByteArray();
        return packet;
    }

    protected void processIncomingResponse(ByteArrayInputStream in) throws DecodingException, IOException {
        AsnDecoderv2c rpdu = new AsnDecoderv2c();
        AsnPduSequence pduSeq = rpdu.DecodeSNMPv2c(in, this.getCommunity());
        if (pduSeq != null) {
            Integer rid = new Integer(pduSeq.getReqId());
            Pdu answ = this.getPdu(rid);
            if (answ != null) {
                answ.fillin(pduSeq);
            } else if (AsnObject.debug > 3) {
                System.out.println(this.getClass().getName() + ".processIncomingResponse(): No Pdu with reqid " + rid);
            }
        } else if (AsnObject.debug > 3) {
            System.out.println(this.getClass().getName() + ".processIncomingResponse(): Error - missing seq input");
        }
    }

    public Pdu processIncomingPdu(byte[] message) throws DecodingException, IOException {
        AsnDecoderv2c rpdu = new AsnDecoderv2c();
        ByteArrayInputStream in = new ByteArrayInputStream(message);
        AsnPduSequence pduSeq = rpdu.DecodeSNMPv2c(in, this.getCommunity());
        Pdu pdu = null;
        if (pduSeq != null) {
            byte type = pduSeq.getRespType();
            switch (type) {
                case -96: {
                    pdu = new GetPdu(this);
                    break;
                }
                case -95: {
                    pdu = new GetNextPdu(this);
                    break;
                }
                case -93: {
                    pdu = new SetPdu(this);
                    break;
                }
                case -91: {
                    pdu = new GetBulkPdu(this);
                    break;
                }
                case -90: {
                    pdu = new InformPdu(this);
                    break;
                }
                case -89: {
                    pdu = new TrapPduv2(this);
                    break;
                }
                default: {
                    if (AsnObject.debug <= 3) break;
                    System.out.println(this.getClass().getName() + ".ProcessIncomingPdu(): PDU received with type " + pduSeq.getRespTypeString() + ". Ignoring it.");
                }
            }
            if (pdu != null) {
                pdu.fillin(pduSeq);
            }
        }
        return pdu;
    }

    public Object clone() throws CloneNotSupportedException {
        SnmpContextv2c clContext = null;
        try {
            clContext = new SnmpContextv2c(this.hostname, this.hostPort, this.bindAddr, this.typeSocket);
            clContext.setCommunity(new String(this.community));
        }
        catch (IOException exc) {
            throw new CloneNotSupportedException("IOException " + exc.getMessage());
        }
        return clContext;
    }

    public String getHashKey() {
        String str = this.hostname + "_" + this.hostPort + "_" + this.typeSocket + "_" + this.community + "_v" + this.getVersion();
        return str;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("SnmpContextv2c[");
        buffer.append("host=").append(this.hostname);
        buffer.append(", port=").append(this.hostPort);
        buffer.append(", bindAddress=").append(this.bindAddr);
        buffer.append(", socketType=").append(this.typeSocket);
        buffer.append(", community=").append(this.community);
        buffer.append(", #trapListeners=").append(this.trapSupport.getListenerCount());
        buffer.append(", #pduListeners=").append(this.pduSupport.getListenerCount());
        buffer.append("]");
        return buffer.toString();
    }
}

