/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.factory;

import java.util.HashMap;
import java.util.Map;
import org.apache.tiles.TilesApplicationContext;
import org.apache.tiles.TilesContainer;
import org.apache.tiles.awareness.TilesApplicationContextAware;
import org.apache.tiles.context.TilesRequestContextFactory;
import org.apache.tiles.definition.DefinitionsFactory;
import org.apache.tiles.evaluator.AttributeEvaluator;
import org.apache.tiles.factory.TilesContainerFactory;
import org.apache.tiles.impl.BasicTilesContainer;
import org.apache.tiles.impl.KeyedDefinitionsFactoryTilesContainer;
import org.apache.tiles.impl.mgmt.CachingKeyedDefinitionsFactoryTilesContainer;
import org.apache.tiles.mgmt.MutableTilesContainer;
import org.apache.tiles.reflect.ClassUtil;
import org.apache.tiles.renderer.RendererFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeyedDefinitionsFactoryTilesContainerFactory
extends TilesContainerFactory {
    public static final String CONTAINER_KEYS_INIT_PARAM = "org.apache.tiles.factory.KeyedDefinitionsFactoryTilesContainerFactory.KEYS";
    public static final String KEY_EXTRACTOR_CLASS_INIT_PARAM = "org.apache.tiles.impl.KeyedDefinitionsFactoryTilesContainer.KeyExtractor";
    protected TilesApplicationContext applicationContext;

    @Override
    public MutableTilesContainer createMutableTilesContainer(TilesApplicationContext context) {
        CachingKeyedDefinitionsFactoryTilesContainer container = new CachingKeyedDefinitionsFactoryTilesContainer();
        this.initializeContainer(context, (BasicTilesContainer)container);
        return container;
    }

    @Override
    public TilesContainer createTilesContainer(TilesApplicationContext context) {
        KeyedDefinitionsFactoryTilesContainer container = new KeyedDefinitionsFactoryTilesContainer();
        this.initializeContainer(context, (BasicTilesContainer)container);
        return container;
    }

    @Deprecated
    public DefinitionsFactory createDefinitionsFactory(Object context) {
        if (context instanceof TilesApplicationContext) {
            this.createDefinitionsFactory((TilesApplicationContext)context);
        }
        throw new UnsupportedOperationException("Class " + context.getClass().getName() + " not recognized a TilesApplicationContext");
    }

    public DefinitionsFactory createDefinitionsFactory(TilesApplicationContext context) {
        HashMap<String, String> config = new HashMap<String, String>(this.defaultConfiguration);
        config.putAll(context.getInitParams());
        DefinitionsFactory retValue = (DefinitionsFactory)KeyedDefinitionsFactoryTilesContainerFactory.createFactory(config, "org.apache.tiles.definition.DefinitionsFactory");
        if (retValue instanceof TilesApplicationContextAware) {
            ((TilesApplicationContextAware)((Object)retValue)).setApplicationContext(this.applicationContext);
        }
        return retValue;
    }

    @Override
    protected void storeContainerDependencies(Object context, Map<String, String> initParameters, Map<String, String> configuration, BasicTilesContainer container) {
        super.storeContainerDependencies(context, initParameters, configuration, container);
        String keyExtractorClassName = configuration.get(KEY_EXTRACTOR_CLASS_INIT_PARAM);
        if (keyExtractorClassName != null && container instanceof KeyedDefinitionsFactoryTilesContainer) {
            ((KeyedDefinitionsFactoryTilesContainer)container).setKeyExtractor((KeyedDefinitionsFactoryTilesContainer.KeyExtractor)ClassUtil.instantiate((String)keyExtractorClassName));
        }
    }

    @Override
    protected void postCreationOperations(TilesRequestContextFactory contextFactory, TilesApplicationContext tilesContext, RendererFactory rendererFactory, AttributeEvaluator evaluator, Map<String, String> initParameters, Map<String, String> configuration, BasicTilesContainer container) {
        super.postCreationOperations(contextFactory, tilesContext, rendererFactory, evaluator, initParameters, configuration, container);
        this.applicationContext = tilesContext;
        String keysString = initParameters.get(CONTAINER_KEYS_INIT_PARAM);
        if (keysString != null && container instanceof KeyedDefinitionsFactoryTilesContainer) {
            String[] keys = keysString.split(",");
            HashMap<String, String> initParams = new HashMap<String, String>(initParameters);
            for (int i = 0; i < keys.length; ++i) {
                String param = initParameters.get("org.apache.tiles.impl.KeyedDefinitionsFactoryTilesContainer.DEFINITIONS_CONFIG@" + keys[i]);
                if (param != null) {
                    initParams.put("org.apache.tiles.definition.DefinitionsFactory.DEFINITIONS_CONFIG", param);
                } else {
                    initParams.remove("org.apache.tiles.definition.DefinitionsFactory.DEFINITIONS_CONFIG");
                }
                DefinitionsFactory defsFactory = (DefinitionsFactory)KeyedDefinitionsFactoryTilesContainerFactory.createFactory(configuration, "org.apache.tiles.definition.DefinitionsFactory");
                if (defsFactory instanceof TilesApplicationContextAware) {
                    ((TilesApplicationContextAware)((Object)defsFactory)).setApplicationContext(tilesContext);
                }
                defsFactory.init(initParams);
                ((KeyedDefinitionsFactoryTilesContainer)container).setDefinitionsFactory(keys[i], defsFactory);
            }
        }
    }
}

