/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import java.util.Arrays;
import junit.framework.TestCase;
import org.xbill.DNS.DNSInput;
import org.xbill.DNS.DNSOutput;
import org.xbill.DNS.KEYBase;
import org.xbill.DNS.Name;
import org.xbill.DNS.Options;
import org.xbill.DNS.Record;
import org.xbill.DNS.TextParseException;
import org.xbill.DNS.Tokenizer;
import org.xbill.DNS.utils.base64;

public class KEYBaseTest
extends TestCase {
    public void test_ctor() throws TextParseException {
        TestClass tc = new TestClass();
        KEYBaseTest.assertEquals((int)0, (int)tc.getFlags());
        KEYBaseTest.assertEquals((int)0, (int)tc.getProtocol());
        KEYBaseTest.assertEquals((int)0, (int)tc.getAlgorithm());
        KEYBaseTest.assertNull((Object)tc.getKey());
        Name n = Name.fromString("my.name.");
        byte[] key = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
        tc = new TestClass(n, 25, 1, 100L, 255, 15, 14, key);
        KEYBaseTest.assertSame((Object)n, (Object)tc.getName());
        KEYBaseTest.assertEquals((int)25, (int)tc.getType());
        KEYBaseTest.assertEquals((int)1, (int)tc.getDClass());
        KEYBaseTest.assertEquals((long)100L, (long)tc.getTTL());
        KEYBaseTest.assertEquals((int)255, (int)tc.getFlags());
        KEYBaseTest.assertEquals((int)15, (int)tc.getProtocol());
        KEYBaseTest.assertEquals((int)14, (int)tc.getAlgorithm());
        KEYBaseTest.assertTrue((boolean)Arrays.equals(key, tc.getKey()));
    }

    public void test_rrFromWire() throws IOException {
        byte[] raw = new byte[]{-85, -51, -17, 25, 1, 2, 3, 4, 5};
        DNSInput in = new DNSInput(raw);
        TestClass tc = new TestClass();
        tc.rrFromWire(in);
        KEYBaseTest.assertEquals((int)43981, (int)tc.getFlags());
        KEYBaseTest.assertEquals((int)239, (int)tc.getProtocol());
        KEYBaseTest.assertEquals((int)25, (int)tc.getAlgorithm());
        KEYBaseTest.assertTrue((boolean)Arrays.equals(new byte[]{1, 2, 3, 4, 5}, tc.getKey()));
        raw = new byte[]{-70, -38, -1, 40};
        in = new DNSInput(raw);
        tc = new TestClass();
        tc.rrFromWire(in);
        KEYBaseTest.assertEquals((int)47834, (int)tc.getFlags());
        KEYBaseTest.assertEquals((int)255, (int)tc.getProtocol());
        KEYBaseTest.assertEquals((int)40, (int)tc.getAlgorithm());
        KEYBaseTest.assertNull((Object)tc.getKey());
    }

    public void test_rrToString() throws IOException, TextParseException {
        Name n = Name.fromString("my.name.");
        byte[] key = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
        TestClass tc = new TestClass(n, 25, 1, 100L, 255, 15, 14, null);
        String out = tc.rrToString();
        KEYBaseTest.assertEquals((String)"255 15 14", (String)out);
        tc = new TestClass(n, 25, 1, 100L, 255, 15, 14, key);
        out = tc.rrToString();
        KEYBaseTest.assertEquals((String)("255 15 14 " + base64.toString(key)), (String)out);
        Options.set("multiline");
        out = tc.rrToString();
        KEYBaseTest.assertEquals((String)("255 15 14 (\n\t" + base64.toString(key) + " ) ; key_tag = 18509"), (String)out);
        Options.unset("multiline");
    }

    public void test_getFootprint() throws TextParseException {
        Name n = Name.fromString("my.name.");
        byte[] key = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
        TestClass tc = new TestClass(n, 25, 1, 100L, 255, 15, 1, key);
        int foot = tc.getFootprint();
        KEYBaseTest.assertEquals((int)3342, (int)foot);
        KEYBaseTest.assertEquals((int)foot, (int)tc.getFootprint());
        tc = new TestClass(n, 25, 1, 100L, 35243, 205, 239, new byte[]{18, 52, 86});
        foot = tc.getFootprint();
        KEYBaseTest.assertEquals((int)49103, (int)foot);
        KEYBaseTest.assertEquals((int)foot, (int)tc.getFootprint());
        tc = new TestClass();
        KEYBaseTest.assertEquals((int)0, (int)tc.getFootprint());
    }

    public void test_rrToWire() throws IOException, TextParseException {
        Name n = Name.fromString("my.name.");
        byte[] key = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
        TestClass tc = new TestClass(n, 25, 1, 100L, 30345, 171, 205, key);
        byte[] exp = new byte[]{118, -119, -85, -51, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
        DNSOutput o = new DNSOutput();
        tc.rrToWire(o, null, true);
        KEYBaseTest.assertTrue((boolean)Arrays.equals(exp, o.toByteArray()));
        o = new DNSOutput();
        tc.rrToWire(o, null, false);
        KEYBaseTest.assertTrue((boolean)Arrays.equals(exp, o.toByteArray()));
    }

    private static class TestClass
    extends KEYBase {
        public TestClass() {
        }

        public TestClass(Name name, int type, int dclass, long ttl, int flags, int proto, int alg, byte[] key) {
            super(name, type, dclass, ttl, flags, proto, alg, key);
        }

        public Record getObject() {
            return null;
        }

        void rdataFromString(Tokenizer st, Name origin) throws IOException {
        }
    }
}

