/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.base.JRBoxPen;
import net.sf.jasperreports.engine.type.RotationEnum;

public final class JRBoxUtil {
    public static JRLineBox copyBordersNoPadding(JRLineBox box, boolean keepLeft, boolean keepRight, boolean keepTop, boolean keepBottom, JRLineBox complementaryBox) {
        JRLineBox clone = box.clone(box.getBoxContainer());
        clone.setTopPadding((Integer)0);
        clone.setLeftPadding((Integer)0);
        clone.setBottomPadding((Integer)0);
        clone.setRightPadding((Integer)0);
        if (!keepLeft || box.getLeftPen().getLineWidth().floatValue() <= 0.0f) {
            if (complementaryBox != null) {
                clone.getLeftPen().setLineWidth(complementaryBox.getLeftPen().getLineWidth());
                clone.getLeftPen().setLineColor(complementaryBox.getLeftPen().getLineColor());
                clone.getLeftPen().setLineStyle(complementaryBox.getLeftPen().getLineStyleValue());
            } else {
                clone.getLeftPen().setLineWidth(Float.valueOf(0.0f));
            }
        }
        if (!keepRight || box.getRightPen().getLineWidth().floatValue() <= 0.0f) {
            if (complementaryBox != null) {
                clone.getRightPen().setLineWidth(complementaryBox.getRightPen().getLineWidth());
                clone.getRightPen().setLineColor(complementaryBox.getRightPen().getLineColor());
                clone.getRightPen().setLineStyle(complementaryBox.getRightPen().getLineStyleValue());
            } else {
                clone.getRightPen().setLineWidth(Float.valueOf(0.0f));
            }
        }
        if (!keepTop || box.getTopPen().getLineWidth().floatValue() <= 0.0f) {
            if (complementaryBox != null) {
                clone.getTopPen().setLineWidth(complementaryBox.getTopPen().getLineWidth());
                clone.getTopPen().setLineColor(complementaryBox.getTopPen().getLineColor());
                clone.getTopPen().setLineStyle(complementaryBox.getTopPen().getLineStyleValue());
            } else {
                clone.getTopPen().setLineWidth(Float.valueOf(0.0f));
            }
        }
        if (!keepBottom || box.getBottomPen().getLineWidth().floatValue() <= 0.0f) {
            if (complementaryBox != null) {
                clone.getBottomPen().setLineWidth(complementaryBox.getBottomPen().getLineWidth());
                clone.getBottomPen().setLineColor(complementaryBox.getBottomPen().getLineColor());
                clone.getBottomPen().setLineStyle(complementaryBox.getBottomPen().getLineStyleValue());
            } else {
                clone.getBottomPen().setLineWidth(Float.valueOf(0.0f));
            }
        }
        return clone;
    }

    public static void reset(JRLineBox box, boolean resetLeft, boolean resetRight, boolean resetTop, boolean resetBottom) {
        if (resetLeft) {
            box.getLeftPen().setLineWidth(Float.valueOf(0.0f));
        }
        if (resetRight) {
            box.getRightPen().setLineWidth(Float.valueOf(0.0f));
        }
        if (resetTop) {
            box.getTopPen().setLineWidth(Float.valueOf(0.0f));
        }
        if (resetBottom) {
            box.getBottomPen().setLineWidth(Float.valueOf(0.0f));
        }
    }

    public static void copy(JRLineBox source, JRLineBox dest) {
        dest.setLeftPadding(source.getOwnLeftPadding());
        dest.copyLeftPen(source.getLeftPen());
        dest.setRightPadding(source.getOwnRightPadding());
        dest.copyRightPen(source.getRightPen());
        dest.setTopPadding(source.getOwnTopPadding());
        dest.copyTopPen(source.getTopPen());
        dest.setBottomPadding(source.getOwnBottomPadding());
        dest.copyBottomPen(source.getBottomPen());
        dest.setPadding(source.getOwnPadding());
        dest.copyPen(source.getPen());
    }

    public static void rotate(JRLineBox box, RotationEnum rotation) {
        switch (rotation) {
            case LEFT: {
                JRBoxPen topPen = box.getTopPen();
                Integer topPadding = box.getTopPadding();
                box.copyTopPen(box.getLeftPen());
                box.setTopPadding(box.getLeftPadding());
                box.copyLeftPen(box.getBottomPen());
                box.setLeftPadding(box.getBottomPadding());
                box.copyBottomPen(box.getRightPen());
                box.setBottomPadding(box.getRightPadding());
                box.copyRightPen(topPen);
                box.setRightPadding(topPadding);
                break;
            }
            case RIGHT: {
                JRBoxPen topPen = box.getTopPen();
                Integer topPadding = box.getTopPadding();
                box.copyTopPen(box.getRightPen());
                box.setTopPadding(box.getRightPadding());
                box.copyRightPen(box.getBottomPen());
                box.setRightPadding(box.getBottomPadding());
                box.copyBottomPen(box.getLeftPen());
                box.setBottomPadding(box.getLeftPadding());
                box.copyLeftPen(topPen);
                box.setLeftPadding(topPadding);
                break;
            }
            case UPSIDE_DOWN: {
                JRBoxPen topPen = box.getTopPen();
                Integer topPadding = box.getTopPadding();
                box.copyTopPen(box.getBottomPen());
                box.setTopPadding(box.getBottomPadding());
                box.copyBottomPen(topPen);
                box.setBottomPadding(topPadding);
                JRBoxPen leftPen = box.getLeftPen();
                Integer leftPadding = box.getLeftPadding();
                box.copyLeftPen(box.getRightPen());
                box.setLeftPadding(box.getRightPadding());
                box.copyRightPen(leftPen);
                box.setRightPadding(leftPadding);
                break;
            }
        }
    }

    public static void eraseBox(JRLineBox box) {
        box.setBottomPadding((Integer)0);
        box.setTopPadding((Integer)0);
        box.setLeftPadding((Integer)0);
        box.setRightPadding((Integer)0);
        box.getBottomPen().setLineWidth(Float.valueOf(0.0f));
        box.getTopPen().setLineWidth(Float.valueOf(0.0f));
        box.getLeftPen().setLineWidth(Float.valueOf(0.0f));
        box.getRightPen().setLineWidth(Float.valueOf(0.0f));
    }

    private JRBoxUtil() {
    }
}

