/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.oasis;

import java.awt.Dimension;
import java.awt.geom.Dimension2D;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRPrintImage;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.export.JRExporterGridCell;
import net.sf.jasperreports.engine.export.oasis.DocumentBuilder;
import net.sf.jasperreports.engine.export.oasis.InternalImageProcessorResult;
import net.sf.jasperreports.engine.type.ModeEnum;
import net.sf.jasperreports.engine.util.ImageUtil;
import net.sf.jasperreports.renderers.DimensionRenderable;
import net.sf.jasperreports.renderers.Renderable;
import net.sf.jasperreports.renderers.RenderersCache;
import net.sf.jasperreports.renderers.ResourceRenderer;
import net.sf.jasperreports.renderers.util.RendererUtil;

public class InternalImageProcessor {
    private final JRPrintImage imageElement;
    private final RenderersCache imageRenderersCache;
    private final JRExporterGridCell cell;
    private final int availableImageWidth;
    private final int availableImageHeight;
    private final DocumentBuilder documentBuilder;
    private final JasperReportsContext jasperReportsContext;

    public InternalImageProcessor(JRPrintImage imageElement, JRExporterGridCell cell, int availableImageWidth, int availableImageHeight, DocumentBuilder documentBuilder, JasperReportsContext jasperReportsContext) {
        this.imageElement = imageElement;
        this.imageRenderersCache = imageElement.isUsingCache() ? documentBuilder.getRenderersCache() : new RenderersCache(jasperReportsContext);
        this.cell = cell;
        this.availableImageWidth = availableImageWidth;
        this.availableImageHeight = availableImageHeight;
        this.documentBuilder = documentBuilder;
        this.jasperReportsContext = jasperReportsContext;
    }

    public InternalImageProcessorResult process(Renderable renderer) throws JRException {
        boolean isLazy = RendererUtil.isLazy(renderer);
        if (!isLazy && renderer instanceof ResourceRenderer) {
            renderer = this.imageRenderersCache.getLoadedRenderer((ResourceRenderer)renderer);
        }
        int imageWidth = this.availableImageWidth;
        int imageHeight = this.availableImageHeight;
        int xoffset = 0;
        int yoffset = 0;
        double cropTop = 0.0;
        double cropLeft = 0.0;
        double cropBottom = 0.0;
        double cropRight = 0.0;
        double angle = 0.0;
        block0 : switch (this.imageElement.getScaleImageValue()) {
            case FILL_FRAME: {
                switch (this.imageElement.getRotation()) {
                    case LEFT: {
                        imageWidth = this.availableImageHeight;
                        imageHeight = this.availableImageWidth;
                        xoffset = 0;
                        yoffset = this.availableImageHeight;
                        angle = 1.5707963267948966;
                        break block0;
                    }
                    case RIGHT: {
                        imageWidth = this.availableImageHeight;
                        imageHeight = this.availableImageWidth;
                        xoffset = this.availableImageWidth;
                        yoffset = 0;
                        angle = -1.5707963267948966;
                        break block0;
                    }
                    case UPSIDE_DOWN: {
                        imageWidth = this.availableImageWidth;
                        imageHeight = this.availableImageHeight;
                        xoffset = this.availableImageWidth;
                        yoffset = this.availableImageHeight;
                        angle = Math.PI;
                        break block0;
                    }
                }
                imageWidth = this.availableImageWidth;
                imageHeight = this.availableImageHeight;
                xoffset = 0;
                yoffset = 0;
                angle = 0.0;
                break;
            }
            case CLIP: {
                Dimension2D dimension;
                double normalWidth = this.availableImageWidth;
                double normalHeight = this.availableImageHeight;
                DimensionRenderable dimensionRenderer = this.imageRenderersCache.getDimensionRenderable(renderer);
                Dimension2D dimension2D = dimension = dimensionRenderer == null ? null : dimensionRenderer.getDimension(this.jasperReportsContext);
                if (dimension != null) {
                    normalWidth = dimension.getWidth();
                    normalHeight = dimension.getHeight();
                }
                switch (this.imageElement.getRotation()) {
                    case LEFT: {
                        imageWidth = this.availableImageHeight;
                        imageHeight = this.availableImageWidth;
                        switch (this.imageElement.getHorizontalImageAlign()) {
                            case RIGHT: {
                                cropLeft = normalWidth - (double)this.availableImageHeight;
                                cropRight = 0.0;
                                yoffset = imageWidth;
                                break;
                            }
                            case CENTER: {
                                cropRight = cropLeft = (normalWidth - (double)this.availableImageHeight) / 2.0;
                                yoffset = this.availableImageHeight - (this.availableImageHeight - imageWidth) / 2;
                                break;
                            }
                            default: {
                                cropLeft = 0.0;
                                cropRight = normalWidth - (double)this.availableImageHeight;
                                yoffset = this.availableImageHeight;
                            }
                        }
                        switch (this.imageElement.getVerticalImageAlign()) {
                            case TOP: {
                                cropTop = 0.0;
                                cropBottom = normalHeight - (double)this.availableImageWidth;
                                xoffset = 0;
                                break;
                            }
                            case MIDDLE: {
                                cropBottom = cropTop = (normalHeight - (double)this.availableImageWidth) / 2.0;
                                xoffset = (this.availableImageWidth - imageHeight) / 2;
                                break;
                            }
                            default: {
                                cropTop = normalHeight - (double)this.availableImageWidth;
                                cropBottom = 0.0;
                                xoffset = this.availableImageWidth - imageHeight;
                            }
                        }
                        angle = 1.5707963267948966;
                        break block0;
                    }
                    case RIGHT: {
                        imageWidth = this.availableImageHeight;
                        imageHeight = this.availableImageWidth;
                        switch (this.imageElement.getHorizontalImageAlign()) {
                            case RIGHT: {
                                cropLeft = normalWidth - (double)this.availableImageHeight;
                                cropRight = 0.0;
                                yoffset = this.availableImageHeight - imageWidth;
                                break;
                            }
                            case CENTER: {
                                cropRight = cropLeft = (normalWidth - (double)this.availableImageHeight) / 2.0;
                                yoffset = (this.availableImageHeight - imageWidth) / 2;
                                break;
                            }
                            default: {
                                cropLeft = 0.0;
                                cropRight = normalWidth - (double)this.availableImageHeight;
                                yoffset = 0;
                            }
                        }
                        switch (this.imageElement.getVerticalImageAlign()) {
                            case TOP: {
                                cropTop = 0.0;
                                cropBottom = normalHeight - (double)this.availableImageWidth;
                                xoffset = this.availableImageWidth;
                                break;
                            }
                            case MIDDLE: {
                                cropBottom = cropTop = (normalHeight - (double)this.availableImageWidth) / 2.0;
                                xoffset = this.availableImageWidth - (this.availableImageWidth - imageHeight) / 2;
                                break;
                            }
                            default: {
                                cropTop = normalHeight - (double)this.availableImageWidth;
                                cropBottom = 0.0;
                                xoffset = imageHeight;
                            }
                        }
                        angle = -1.5707963267948966;
                        break block0;
                    }
                    case UPSIDE_DOWN: {
                        imageWidth = (int)Math.min(normalWidth, (double)this.availableImageWidth);
                        imageHeight = (int)Math.min(normalHeight, (double)this.availableImageHeight);
                        switch (this.imageElement.getHorizontalImageAlign()) {
                            case RIGHT: {
                                cropLeft = normalWidth - (double)this.availableImageWidth;
                                cropRight = 0.0;
                                xoffset = imageWidth;
                                break;
                            }
                            case CENTER: {
                                cropRight = cropLeft = (normalWidth - (double)this.availableImageWidth) / 2.0;
                                xoffset = this.availableImageWidth - (this.availableImageWidth - imageWidth) / 2;
                                break;
                            }
                            default: {
                                cropLeft = 0.0;
                                cropRight = normalWidth - (double)this.availableImageWidth;
                                xoffset = this.availableImageWidth;
                            }
                        }
                        switch (this.imageElement.getVerticalImageAlign()) {
                            case TOP: {
                                cropTop = 0.0;
                                cropBottom = normalHeight - (double)this.availableImageHeight;
                                yoffset = this.availableImageHeight;
                                break;
                            }
                            case MIDDLE: {
                                cropBottom = cropTop = (normalHeight - (double)this.availableImageHeight) / 2.0;
                                yoffset = this.availableImageHeight - (this.availableImageHeight - imageHeight) / 2;
                                break;
                            }
                            default: {
                                cropTop = normalHeight - (double)this.availableImageHeight;
                                cropBottom = 0.0;
                                yoffset = imageHeight;
                            }
                        }
                        angle = Math.PI;
                        break block0;
                    }
                }
                imageWidth = this.availableImageWidth;
                imageHeight = this.availableImageHeight;
                switch (this.imageElement.getHorizontalImageAlign()) {
                    case RIGHT: {
                        cropLeft = normalWidth - (double)this.availableImageWidth;
                        cropRight = 0.0;
                        xoffset = this.availableImageWidth - imageWidth;
                        break;
                    }
                    case CENTER: {
                        cropRight = cropLeft = (normalWidth - (double)this.availableImageWidth) / 2.0;
                        xoffset = (this.availableImageWidth - imageWidth) / 2;
                        break;
                    }
                    default: {
                        cropLeft = 0.0;
                        cropRight = normalWidth - (double)this.availableImageWidth;
                        xoffset = 0;
                    }
                }
                switch (this.imageElement.getVerticalImageAlign()) {
                    case TOP: {
                        cropTop = 0.0;
                        cropBottom = normalHeight - (double)this.availableImageHeight;
                        yoffset = 0;
                        break;
                    }
                    case MIDDLE: {
                        cropBottom = cropTop = (normalHeight - (double)this.availableImageHeight) / 2.0;
                        yoffset = (this.availableImageHeight - imageHeight) / 2;
                        break;
                    }
                    default: {
                        cropTop = normalHeight - (double)this.availableImageHeight;
                        cropBottom = 0.0;
                        yoffset = this.availableImageHeight - imageHeight;
                    }
                }
                angle = 0.0;
                break;
            }
            default: {
                double normalWidth = this.availableImageWidth;
                double normalHeight = this.availableImageHeight;
                if (!isLazy) {
                    Dimension2D dimension;
                    DimensionRenderable dimensionRenderer = this.imageRenderersCache.getDimensionRenderable(renderer);
                    Dimension2D dimension2D = dimension = dimensionRenderer == null ? null : dimensionRenderer.getDimension(this.jasperReportsContext);
                    if (dimension != null) {
                        normalWidth = dimension.getWidth();
                        normalHeight = dimension.getHeight();
                    }
                }
                double ratioX = 1.0;
                double ratioY = 1.0;
                switch (this.imageElement.getRotation()) {
                    case LEFT: {
                        imageWidth = this.availableImageHeight;
                        imageHeight = this.availableImageWidth;
                        ratioX = (double)this.availableImageWidth / normalHeight;
                        ratioY = (double)this.availableImageHeight / normalWidth;
                        ratioY = ratioX = ratioX < ratioY ? ratioX : ratioY;
                        xoffset = 0;
                        yoffset = this.availableImageHeight;
                        cropLeft = (int)((double)ImageUtil.getXAlignFactor(this.imageElement) * (normalWidth - (double)this.availableImageHeight / ratioX));
                        cropRight = (int)((double)(1.0f - ImageUtil.getXAlignFactor(this.imageElement)) * (normalWidth - (double)this.availableImageHeight / ratioX));
                        cropTop = (int)((double)ImageUtil.getYAlignFactor(this.imageElement) * (normalHeight - (double)this.availableImageWidth / ratioY));
                        cropBottom = (int)((double)(1.0f - ImageUtil.getYAlignFactor(this.imageElement)) * (normalHeight - (double)this.availableImageWidth / ratioY));
                        angle = 1.5707963267948966;
                        break block0;
                    }
                    case RIGHT: {
                        imageWidth = this.availableImageHeight;
                        imageHeight = this.availableImageWidth;
                        ratioX = (double)this.availableImageWidth / normalHeight;
                        ratioY = (double)this.availableImageHeight / normalWidth;
                        ratioY = ratioX = ratioX < ratioY ? ratioX : ratioY;
                        xoffset = this.availableImageWidth;
                        yoffset = 0;
                        cropLeft = (int)((double)ImageUtil.getXAlignFactor(this.imageElement) * (normalWidth - (double)this.availableImageHeight / ratioX));
                        cropRight = (int)((double)(1.0f - ImageUtil.getXAlignFactor(this.imageElement)) * (normalWidth - (double)this.availableImageHeight / ratioX));
                        cropTop = (int)((double)ImageUtil.getYAlignFactor(this.imageElement) * (normalHeight - (double)this.availableImageWidth / ratioY));
                        cropBottom = (int)((double)(1.0f - ImageUtil.getYAlignFactor(this.imageElement)) * (normalHeight - (double)this.availableImageWidth / ratioY));
                        angle = -1.5707963267948966;
                        break block0;
                    }
                    case UPSIDE_DOWN: {
                        imageWidth = this.availableImageWidth;
                        imageHeight = this.availableImageHeight;
                        ratioX = (double)this.availableImageWidth / normalWidth;
                        ratioY = (double)this.availableImageHeight / normalHeight;
                        ratioY = ratioX = ratioX < ratioY ? ratioX : ratioY;
                        xoffset = this.availableImageWidth;
                        yoffset = this.availableImageHeight;
                        cropLeft = (int)((double)ImageUtil.getXAlignFactor(this.imageElement) * (normalWidth - (double)this.availableImageWidth / ratioX));
                        cropRight = (int)((double)(1.0f - ImageUtil.getXAlignFactor(this.imageElement)) * (normalWidth - (double)this.availableImageWidth / ratioX));
                        cropTop = (int)((double)ImageUtil.getYAlignFactor(this.imageElement) * (normalHeight - (double)this.availableImageHeight / ratioY));
                        cropBottom = (int)((double)(1.0f - ImageUtil.getYAlignFactor(this.imageElement)) * (normalHeight - (double)this.availableImageHeight / ratioY));
                        angle = Math.PI;
                        break block0;
                    }
                }
                imageWidth = this.availableImageWidth;
                imageHeight = this.availableImageHeight;
                ratioX = (double)this.availableImageWidth / normalWidth;
                ratioY = (double)this.availableImageHeight / normalHeight;
                ratioY = ratioX = ratioX < ratioY ? ratioX : ratioY;
                xoffset = 0;
                yoffset = 0;
                cropLeft = (int)((double)ImageUtil.getXAlignFactor(this.imageElement) * (normalWidth - (double)this.availableImageWidth / ratioX));
                cropRight = (int)((double)(1.0f - ImageUtil.getXAlignFactor(this.imageElement)) * (normalWidth - (double)this.availableImageWidth / ratioX));
                cropTop = (int)((double)ImageUtil.getYAlignFactor(this.imageElement) * (normalHeight - (double)this.availableImageHeight / ratioY));
                cropBottom = (int)((double)(1.0f - ImageUtil.getYAlignFactor(this.imageElement)) * (normalHeight - (double)this.availableImageHeight / ratioY));
                angle = 0.0;
            }
        }
        String imagePath = this.documentBuilder.getImagePath(renderer, new Dimension(this.availableImageWidth, this.availableImageHeight), ModeEnum.OPAQUE == this.imageElement.getModeValue() ? this.imageElement.getBackcolor() : null, this.cell, isLazy, this.imageRenderersCache);
        return new InternalImageProcessorResult(imagePath, imageWidth, imageHeight, xoffset, yoffset, cropTop, cropLeft, cropBottom, cropRight, angle);
    }
}

