/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.crosstabs.base;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import net.sf.jasperreports.crosstabs.JRCrosstabBucket;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.analytics.dataset.BucketOrder;
import net.sf.jasperreports.engine.base.JRBaseObjectFactory;
import net.sf.jasperreports.engine.type.SortOrderEnum;
import net.sf.jasperreports.engine.util.JRClassLoader;
import net.sf.jasperreports.engine.util.JRCloneUtils;

public class JRBaseCrosstabBucket
implements JRCrosstabBucket,
Serializable {
    private static final long serialVersionUID = 10200L;
    public static final String EXCEPTION_MESSAGE_KEY_BUCKET_LOAD_ERROR = "crosstabs.bucket.load.error";
    protected String valueClassName;
    protected String valueClassRealName;
    protected Class<?> valueClass;
    @Deprecated
    protected SortOrderEnum orderValue = SortOrderEnum.ASCENDING;
    protected BucketOrder bucketOrder = BucketOrder.ASCENDING;
    protected JRExpression expression;
    protected JRExpression orderByExpression;
    protected JRExpression comparatorExpression;
    private int PSEUDO_SERIAL_VERSION_UID = 60002;
    private byte order;

    protected JRBaseCrosstabBucket() {
    }

    public JRBaseCrosstabBucket(JRCrosstabBucket bucket, JRBaseObjectFactory factory) {
        factory.put(bucket, this);
        this.valueClassName = bucket.getValueClassName();
        this.bucketOrder = bucket.getOrder();
        this.expression = factory.getExpression(bucket.getExpression());
        this.orderByExpression = factory.getExpression(bucket.getOrderByExpression());
        this.comparatorExpression = factory.getExpression(bucket.getComparatorExpression());
    }

    @Override
    public String getValueClassName() {
        return this.valueClassName;
    }

    @Override
    public BucketOrder getOrder() {
        return this.bucketOrder;
    }

    @Override
    public JRExpression getExpression() {
        return this.expression;
    }

    @Override
    public JRExpression getOrderByExpression() {
        return this.orderByExpression;
    }

    @Override
    public JRExpression getComparatorExpression() {
        return this.comparatorExpression;
    }

    @Override
    public Class<?> getValueClass() {
        String className;
        if (this.valueClass == null && (className = this.getValueClassRealName()) != null) {
            try {
                this.valueClass = JRClassLoader.loadClassForName(className);
            }
            catch (ClassNotFoundException e) {
                throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_BUCKET_LOAD_ERROR, null, e);
            }
        }
        return this.valueClass;
    }

    private String getValueClassRealName() {
        if (this.valueClassRealName == null) {
            this.valueClassRealName = JRClassLoader.getClassRealName(this.valueClassName);
        }
        return this.valueClassRealName;
    }

    @Override
    public Object clone() {
        JRBaseCrosstabBucket clone = null;
        try {
            clone = (JRBaseCrosstabBucket)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new JRRuntimeException(e);
        }
        clone.expression = JRCloneUtils.nullSafeClone(this.expression);
        clone.orderByExpression = JRCloneUtils.nullSafeClone(this.orderByExpression);
        clone.comparatorExpression = JRCloneUtils.nullSafeClone(this.comparatorExpression);
        return clone;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.PSEUDO_SERIAL_VERSION_UID < 30702) {
            SortOrderEnum sortOrder = SortOrderEnum.getByValue(this.order);
            this.bucketOrder = BucketOrder.fromSortOrderEnum(sortOrder);
        } else if (this.orderValue != null && this.bucketOrder == null) {
            this.bucketOrder = BucketOrder.fromSortOrderEnum(this.orderValue);
            this.orderValue = null;
        }
        if (this.PSEUDO_SERIAL_VERSION_UID < 40003) {
            this.valueClassName = this.getExpression().getValueClassName();
        }
    }
}

