/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap;

import com.novell.ldap.LDAPControl;
import com.novell.ldap.LDAPException;
import com.novell.ldap.LDAPMessage;
import com.novell.ldap.asn1.ASN1Boolean;
import com.novell.ldap.asn1.ASN1Object;
import com.novell.ldap.rfc2251.RfcControls;
import com.novell.ldap.rfc2251.RfcLDAPDN;
import com.novell.ldap.rfc2251.RfcLDAPMessage;
import com.novell.ldap.rfc2251.RfcLDAPSuperDN;
import com.novell.ldap.rfc2251.RfcModifyDNRequest;
import com.novell.ldap.rfc2251.RfcRelativeLDAPDN;
import java.io.IOException;

public class LDAPModifyDNRequest
extends LDAPMessage {
    public LDAPModifyDNRequest() {
        super(12);
    }

    public LDAPModifyDNRequest(String dn, String newRdn, String newParentdn, boolean deleteOldRdn, LDAPControl[] cont) throws LDAPException {
        super(12, new RfcModifyDNRequest(new RfcLDAPDN(dn), new RfcRelativeLDAPDN(newRdn), new ASN1Boolean(deleteOldRdn), newParentdn != null ? new RfcLDAPSuperDN(newParentdn) : null), cont);
    }

    public String getDN() {
        return this.getASN1Object().getRequestDN();
    }

    public String getNewRDN() {
        RfcModifyDNRequest req = (RfcModifyDNRequest)this.getASN1Object().getRequest();
        RfcRelativeLDAPDN relDN = (RfcRelativeLDAPDN)req.toArray()[1];
        return relDN.stringValue();
    }

    public boolean getDeleteOldRDN() {
        RfcModifyDNRequest req = (RfcModifyDNRequest)this.getASN1Object().getRequest();
        ASN1Boolean delOld = (ASN1Boolean)req.toArray()[2];
        return delOld.booleanValue();
    }

    public String getParentDN() {
        RfcModifyDNRequest req = (RfcModifyDNRequest)this.getASN1Object().getRequest();
        ASN1Object[] seq = req.toArray();
        if (seq.length < 4 || seq[3] == null) {
            return null;
        }
        RfcLDAPSuperDN parentDN = (RfcLDAPSuperDN)req.toArray()[3];
        return parentDN.stringValue();
    }

    public String toString() {
        return this.getASN1Object().toString();
    }

    protected void setDeserializedValues(LDAPMessage readObject, RfcControls asn1Ctrls) throws IOException, ClassNotFoundException {
        if (!(readObject instanceof LDAPModifyDNRequest)) {
            throw new ClassNotFoundException("Error occured while deserializing LDAPModifyDNRequest object");
        }
        LDAPModifyDNRequest tmp = (LDAPModifyDNRequest)readObject;
        String dn = tmp.getDN();
        String newRdn = tmp.getNewRDN();
        boolean deleteOldRdn = tmp.getDeleteOldRDN();
        String newParentdn = tmp.getParentDN();
        tmp = null;
        RfcModifyDNRequest operation = new RfcModifyDNRequest(new RfcLDAPDN(dn), new RfcRelativeLDAPDN(newRdn), new ASN1Boolean(deleteOldRdn), newParentdn != null ? new RfcLDAPSuperDN(newParentdn) : null);
        this.message = new RfcLDAPMessage(operation, asn1Ctrls);
        readObject = null;
    }
}

