/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.portlet.context;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.portlet.PortletRequest;
import org.apache.tiles.context.MapEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class PortletParamMap
implements Map<String, String> {
    private PortletRequest request = null;

    public PortletParamMap(PortletRequest request) {
        this.request = request;
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.request.getParameter(this.key(key)) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        Iterator<String> values = this.values().iterator();
        while (values.hasNext()) {
            if (!value.equals(values.next())) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<Map.Entry<String, String>> entrySet() {
        HashSet<Map.Entry<String, String>> set = new HashSet<Map.Entry<String, String>>();
        Enumeration keys = this.request.getParameterNames();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            set.add((Map.Entry<String, String>)new MapEntry((Object)key, (Object)this.request.getParameter(key), false));
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean equals(Object o) {
        PortletRequest otherRequest = ((PortletParamMap)o).request;
        boolean retValue = true;
        PortletRequest portletRequest = this.request;
        synchronized (portletRequest) {
            Enumeration attribs = this.request.getParameterNames();
            while (attribs.hasMoreElements() && retValue) {
                String parameterName = (String)attribs.nextElement();
                retValue = this.request.getParameter(parameterName).equals(otherRequest.getParameter(parameterName));
            }
        }
        return retValue;
    }

    @Override
    public String get(Object key) {
        return this.request.getParameter(this.key(key));
    }

    @Override
    public int hashCode() {
        return this.request.hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this.size() < 1;
    }

    @Override
    public Set<String> keySet() {
        HashSet<String> set = new HashSet<String>();
        Enumeration keys = this.request.getParameterNames();
        while (keys.hasMoreElements()) {
            set.add((String)keys.nextElement());
        }
        return set;
    }

    @Override
    public String put(String key, String value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends String, ? extends String> map) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        int n = 0;
        Enumeration keys = this.request.getParameterNames();
        while (keys.hasMoreElements()) {
            keys.nextElement();
            ++n;
        }
        return n;
    }

    @Override
    public Collection<String> values() {
        ArrayList<String> list = new ArrayList<String>();
        Enumeration keys = this.request.getParameterNames();
        while (keys.hasMoreElements()) {
            list.add(this.request.getParameter((String)keys.nextElement()));
        }
        return list;
    }

    private String key(Object key) {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        if (key instanceof String) {
            return (String)key;
        }
        return key.toString();
    }
}

